package com.yeejoin.amos.boot.module.elevator.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.*;
import com.yeejoin.amos.boot.module.elevator.api.service.*;
import com.yeejoin.amos.boot.module.elevator.api.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


@RestController
@Api(tags = "统计Api")
@RequestMapping(value = "/statistics")
public class StatisticsController extends BaseController {

    @Autowired
    private IAlertStatisticsService alertStatisticsService;

    @Autowired
    private IAlertRescueStatisticsService alertRescueStatisticsService;

    @Autowired
    private IAlertPlaceStatisticsService alertPlaceStatisticsService;

    @Autowired
    private IAlertUseUnitStatisticsService alertUseUnitStatisticsService;

    @Autowired
    private IAlertMaintenanceUnitStatisticsService alertMaintenanceUnitStatisticsService;

    @Autowired
    private IAlertDispatchStatisticsService alertDispatchStatisticsService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/statisticalGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> statisticalGeneration(@RequestParam(value = "type", required = false) String type) {
        alertStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getList")
    @ApiOperation(httpMethod = "GET", value = "查询统计信息", notes = "查询统计信息")
    public ResponseModel<Object> getList(@RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertStatistics> alertStatisticsPage = new Page<>();
        alertStatisticsPage.setRecords(alertStatisticsService.getList(date));
        return ResponseHelper.buildResponse(alertStatisticsPage);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportData")
    @ApiOperation(httpMethod = "GET", value = "监管单位统计信息导出", notes = "监管单位统计信息导出")
    public void exportData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertStatisticsExportVo> exportVos = new ArrayList<>();
        List<AlertStatistics> list = alertStatisticsService.getList(date);
        int number = 1;
        for (AlertStatistics item : list) {
            AlertStatisticsExportVo vo = new AlertStatisticsExportVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }

        ExcelUtil.createTemplate(response, "各地监控中心电梯月度情况综述", "各地监控中心电梯月度情况综述", exportVos, AlertStatisticsExportVo.class, null, false);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/rescueStatisticalGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> rescueStatisticalGeneration(@RequestParam(value = "type", required = false) String type) {
        alertRescueStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/rescueList")
    @ApiOperation(httpMethod = "GET", value = "查询列表", notes = "查询列表")
    public ResponseModel<Object> rescueList(@RequestParam(value = "date", required = false) String date) {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertRescueStatistics> alertRescueStatisticsPage = new Page<>();
        alertRescueStatisticsPage.setRecords(alertRescueStatisticsService.getList(date));
        return ResponseHelper.buildResponse(alertRescueStatisticsPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportRescueData")
    @ApiOperation(httpMethod = "GET", value = "监管单位统计信息导出", notes = "监管单位统计信息导出")
    public void exportRescueData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertRescueStatisticsExportVo> exportVos = new ArrayList<>();
        List<AlertRescueStatistics> list = alertRescueStatisticsService.getList(date);
        int number = 1;
        for (AlertRescueStatistics item : list) {
            AlertRescueStatisticsExportVo vo = new AlertRescueStatisticsExportVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }

        ExcelUtil.createTemplate(response, "各地监控中心困人救援月度情况汇总表", "各地监控中心困人救援月度情况汇总表", exportVos, AlertRescueStatisticsExportVo.class, null, false);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/statisticalPlaceGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> statisticalPlaceGeneration(@RequestParam(value = "type", required = false) String type) {
        alertPlaceStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/placeList")
    @ApiOperation(httpMethod = "GET", value = "查询列表", notes = "查询列表")
    public ResponseModel<Object> placeList(@RequestParam(value = "date", required = false) String date) {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertPlaceStatistics> alertRescueStatisticsPage = new Page<>();
        alertRescueStatisticsPage.setRecords(alertPlaceStatisticsService.placeList(date));
        return ResponseHelper.buildResponse(alertRescueStatisticsPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportPlaceData")
    @ApiOperation(httpMethod = "GET", value = "月度电梯困人故障高发区域统计导出", notes = "月度电梯困人故障高发区域统计导出")
    public void exportPlaceData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertPlaceStatisticsExportVo> exportVos = new ArrayList<>();
        List<AlertPlaceStatistics> list = alertPlaceStatisticsService.placeList(date);
        int number = 1;
        for (AlertPlaceStatistics item : list) {
            AlertPlaceStatisticsExportVo vo = new AlertPlaceStatisticsExportVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }

        ExcelUtil.createTemplate(response, "月度电梯困人故障高发区域统计", "月度电梯困人故障高发区域统计", exportVos, AlertPlaceStatisticsExportVo.class, null, false);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/statisticalUseUnitGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> statisticalUseUnitGeneration(@RequestParam(value = "type", required = false) String type) {
        alertUseUnitStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/useUnitList")
    @ApiOperation(httpMethod = "GET", value = "查询列表", notes = "查询列表")
    public ResponseModel<Object> useUnitList(@RequestParam(value = "date", required = false) String date) {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertUseUnitStatistics> alertRescueStatisticsPage = new Page<>();
        alertRescueStatisticsPage.setRecords(alertUseUnitStatisticsService.getList(date));
        return ResponseHelper.buildResponse(alertRescueStatisticsPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportUseUnitData")
    @ApiOperation(httpMethod = "GET", value = "月度困人故障高发使用单位导出", notes = "月度困人故障高发使用单位导出")
    public void exportUseUnitData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertUseUnitStatisticsVo> exportVos = new ArrayList<>();
        List<AlertUseUnitStatistics> list = alertUseUnitStatisticsService.getList(date);
        int number = 1;
        for (AlertUseUnitStatistics item : list) {
            AlertUseUnitStatisticsVo vo = new AlertUseUnitStatisticsVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }
        ExcelUtil.createTemplate(response, "月度困人故障高发使用单位", "月度困人故障高发使用单位", exportVos, AlertUseUnitStatisticsVo.class, null, false);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/statisticalMaintenanceUnitGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> statisticalMaintenanceUnitGeneration(@RequestParam(value = "type", required = false) String type) {
        alertMaintenanceUnitStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintenanceUnitList")
    @ApiOperation(httpMethod = "GET", value = "查询列表", notes = "查询列表")
    public ResponseModel<Object> maintenanceUnitList(@RequestParam(value = "date", required = false) String date) {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertMaintenanceUnitStatistics> alertRescueStatisticsPage = new Page<>();
        alertRescueStatisticsPage.setRecords(alertMaintenanceUnitStatisticsService.getList(date));
        return ResponseHelper.buildResponse(alertRescueStatisticsPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportMaintenanceUnitData")
    @ApiOperation(httpMethod = "GET", value = "月度故障高发维保单位统计导出", notes = "月度故障高发维保单位统计导出")
    public void exportMaintenanceUnitData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertMaintenanceUnitStatisticsExportVo> exportVos = new ArrayList<>();
        List<AlertMaintenanceUnitStatistics> list = alertMaintenanceUnitStatisticsService.getList(date);
        int number = 1;
        for (AlertMaintenanceUnitStatistics item : list) {
            AlertMaintenanceUnitStatisticsExportVo vo = new AlertMaintenanceUnitStatisticsExportVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }
        ExcelUtil.createTemplate(response, "月度故障高发维保单位统计", "月度故障高发维保单位统计", exportVos, AlertMaintenanceUnitStatisticsExportVo.class, null, false);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/statisticalDispatchGeneration")
    @ApiOperation(httpMethod = "GET", value = "生成统计数据", notes = "生成统计数据")
    public ResponseModel<Object> statisticalDispatchGeneration(@RequestParam(value = "type", required = false) String type) {
        alertDispatchStatisticsService.statisticalGeneration(type);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/dispatchList")
    @ApiOperation(httpMethod = "GET", value = "查询列表", notes = "查询列表")
    public ResponseModel<Object> dispatchList(@RequestParam(value = "date", required = false) String date) {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        Page<AlertDispatchStatistics> alertRescueStatisticsPage = new Page<>();
        alertRescueStatisticsPage.setRecords(alertDispatchStatisticsService.getList(date));
        return ResponseHelper.buildResponse(alertRescueStatisticsPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportDispatchData")
    @ApiOperation(httpMethod = "GET", value = "月度故障高发维保单位统计导出", notes = "月度故障高发维保单位统计导出")
    public void exportDispatchData(HttpServletResponse response, @RequestParam(value = "date", required = false) String date) throws ParseException {
        if (ObjectUtils.isEmpty(date)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Date nowDate = cal.getTime();
            date = format.format(nowDate);
        }
        ArrayList<AlertDispatchStatisticsExportVo> exportVos = new ArrayList<>();
        List<AlertDispatchStatistics> list = alertDispatchStatisticsService.getList(date);
        int number = 1;
        for (AlertDispatchStatistics item : list) {
            AlertDispatchStatisticsExportVo vo = new AlertDispatchStatisticsExportVo();
            BeanUtil.copyProperties(item, vo);
            vo.setNumber(number);
            number = number + 1;
            exportVos.add(vo);
        }
        ExcelUtil.createTemplate(response, "困人救援超时情况统计", "困人救援超时情况统计", exportVos, AlertDispatchStatisticsExportVo.class, null, false);
    }

}
