package com.yeejoin.amos.latentdanger.common.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface LatentDangerState {

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    static LatentDangerState getEnumByCode(String code) {
        return null;
    }

    /**
     * 根据code获取枚举名称
     *
     * @param code
     * @return
     */
    static String getEnumNameByCode(String code) {
        return null;
    }

    enum SupervisionDangerStateEnum implements LatentDangerState {
        /**
         * 提交隐患
         */
        提交隐患("提交隐患", "dangerSubmit", null, null),
        /**
         * 现场确认
         */
        现场确认("现场确认", "onSiteConfirm", "leaderConfirm","onSiteConfirm"),
        /**
         * 检查组长确认
         */
        检查组长确认("检查组长确认", "leaderConfirm", "secondConfirm","onSiteConfirm"),
        /**
         * 隐患二次审核确认
         */
        隐患二次审核确认("隐患二次审核确认", "secondConfirm", "taskDispatch","onSiteConfirm"),
        /**
         * 整改任务分配
         */
        整改任务分配("整改任务分配", "taskDispatch", "governFileSubmit",""),
        /**
         * 提交整改资料
         */
        提交整改资料("提交整改资料", "governFileSubmit", "governChargerConfirm",""),
        /**
         * 整改检查组长确认
         */
        整改检查组长确认("整改检查组长确认", "governLeaderConfirm", "governChargerConfirm","governFileSubmit"),
        /**
         * 整改检查负责人确认
         */
        整改检查负责人确认("整改检查负责人确认", "governChargerConfirm", "governLeadershipConfirm","governFileSubmit"),
        /**
         * 整改检查分管领导确认(根据计划类型不同，分管领导确认完流程不同)
         */
        整改检查分管领导确认("整改检查分管领导确认", "governLeadershipConfirm", "governLeaderReviewConfirm","governFileSubmit"),
        /**
         * 整改检查组长复查确认
         */
        整改检查组长复查确认("整改检查组长复查确认", "governLeaderReviewConfirm", "governSecondReviewConfirm","governFileSubmit"),
        /**
         * 整改二次审核确认
         */
        整改二次审核确认("整改二次审核确认", "governSecondReviewConfirm", "endOfGovernance","governFileSubmit"),
        /**
         * 整改完毕
         */
        整改完毕("整改完毕", "endOfGovernance", "","");

        /**
         * 名称，描述
         */
        private String name;

        /**
         * 编码
         */
        private String code;

        /**
         * 通过下一步骤
         */
        private String next;

        /**
         * 拒绝下一步骤
         */
        private String rejectNext;

        SupervisionDangerStateEnum(String name, String code, String next, String rejectNext) {
            this.name = name;
            this.code = code;
            this.next = next;
            this.rejectNext = rejectNext;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }
        public String getNext() {
            return next;
        }

        public void setNext(String next) {
            this.next = next;
        }

        public String getRejectNext() {
            return rejectNext;
        }

        public void setRejectNext(String rejectNext) {
            this.rejectNext = rejectNext;
        }

        public static SupervisionDangerStateEnum getEnumByCode(String code) {
            for (SupervisionDangerStateEnum _enum : SupervisionDangerStateEnum.values()) {
                if (code.equals(_enum.getCode())) {
                    return _enum;
                }
            }
            return null;
        }

        public static String getEnumNameByCode(String code) {
            String enumName = "";
            for(SupervisionDangerStateEnum type: SupervisionDangerStateEnum.values()) {
                if (type.getCode().equals(code)) {
                    enumName = type.getName();
                    break;
                }
            }
            return enumName;
        }

        public static List<Map<String, String>> getEnumList() {
            List<Map<String, String>> enumList = Lists.newArrayList();
            for(SupervisionDangerStateEnum type: SupervisionDangerStateEnum.values()) {
                Map<String, String> resultMap = Maps.newHashMap();
                resultMap.put("key", type.getCode());
                resultMap.put("name", type.getName());
                enumList.add(resultMap);
            }
            return enumList;
        }
    }

    enum PatrolDangerLevelEnum implements LatentDangerState {
        /**
         * 待评审
         */
        待评审("待评审", "1"),
        待治理("待治理", "2"),
        安措计划中("安措计划中", "3"),
        待验证("待验证", "4"),
        治理完毕("治理完毕", "5"),
        已撤销("已撤销", "6"),
        延期治理申请("延期治理中", "7"),
        延期治理申请待车间部门审核("延期治理待车间部门审核", "8"),
        延期治理申请待公司审核("延期治理待公司审核", "9");

        /**
         * 名称，描述
         */
        private String name;

        /**
         * 编码
         */
        private String code;

        PatrolDangerLevelEnum(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public LatentDangerState getEnumByCode(String code) {
            for (PatrolDangerLevelEnum _enum : PatrolDangerLevelEnum.values()) {
                if (code.equals(_enum.getCode())) {
                    return _enum;
                }
            }
            return null;
        }

        public String getEnumNameByCode(String code) {
            String enumName = "";
            for(PatrolDangerLevelEnum type: PatrolDangerLevelEnum.values()) {
                if (type.getCode().equals(code)) {
                    enumName = type.getName();
                    break;
                }
            }
            return enumName;
        }

        public static List<Map<String, String>> getEnumList() {
            List<Map<String, String>> enumList = Lists.newArrayList();
            for(PatrolDangerLevelEnum type: PatrolDangerLevelEnum.values()) {
                Map<String, String> resultMap = Maps.newHashMap();
                resultMap.put("key", type.getCode());
                resultMap.put("name", type.getName());
                enumList.add(resultMap);
            }
            return enumList;
        }
    }
}
