package com.yeejoin.amos.api.openapi.face.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.openapi.enums.JgFileAttributeEnum;
import com.yeejoin.amos.api.openapi.enums.JgFileObjectEnum;
import com.yeejoin.amos.api.openapi.face.model.StaffQualifInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.StaffQualifInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.JgFile;
import com.yeejoin.amos.api.openapi.face.orm.entity.StaffQualifInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 人员数据信息-资质信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class StaffQualifInfoService extends AppBaseService<StaffQualifInfoModel, StaffQualifInfo, StaffQualifInfoMapper> {

    @Autowired
    private JgFileService fileService;


    /**
     *
     * 新增人员资质信息
     *
     * @param model 人员资质信息model集合
     * @return  成功返回“ok”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveStaffQualifInfo(List<StaffQualifInfoModel> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("人员资质信息为空.");
        }

//        List<JgFile> fileList = new ArrayList<>();
//        List<JgFile> qualificationCertList;

        for (StaffQualifInfoModel models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());

            StaffQualifInfoModel staffQualifInfoModel = this.createWithModel(models);

//            qualificationCertList = JSONObject.parseArray(JSONObject.toJSONString(models.getQualificationCert()), JgFile.class);
//
//            for (JgFile files : qualificationCertList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getOperatorId());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.STAFF_QUALIF_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.QUALIFICATION_CERT.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(staffQualifInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
        }
//        fileService.saveBatch(fileList);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(StaffQualifInfoModel models) {
//        if(ValidationUtil.isEmpty(models.getOperatorId())) {
//            throw new BadRequest("作业人员身份证号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOperationItem())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"作业项目名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOperationItemCode())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"作业项目代号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEffectiveDate())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"有效日期不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getIssuingAuthor())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"发证机关不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getQualificationCert())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"资质证书附件不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"同步状态不能为空！");
//        }
//    }

}
