package com.yeejoin.amos.boot.module.jyjc.biz.service.impl.handler;

import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationHandlerService;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationPushLogServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>
 * ProjectName: amos-boot-biz
 * PackageName: com.yeejoin.amos.boot.module.jyjc.biz.service.impl.handler
 *
 * @author yangyang
 * @version v1.0
 * @date 2023/12/15 16:12
 */
@Component
public class AbstractJyjcInspectionApplicationHandlerServiceImpl implements IJyjcInspectionApplicationHandlerService {

    @Autowired
    private JyjcInspectionApplicationPushLogServiceImpl applicationPushLogService;

    @Override
    public String type() {
        return "default";
    }

    @Override
    public boolean notifyInspectionUnit(Map<String, Object> params) {
        // push日志
        applicationPushLogService.saveInspectionApplicationPushLog(params);
        return true;
    }
}
