package com.yeejoin.amos.boot.module.ymt.api.service;


import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorListDto;

import java.util.List;

/**
 * 关注电梯关系表接口类
 *
 * @author system_generator
 * @date 2021-10-08
 */
public interface IElevatorRelationService {

    /**
     * 获取是否关注电梯
     * @param phone
     * @param elevatorId
     * @return
     */
    Boolean hasFocusElevator(String phone, Long elevatorId);

    /**
     * 关注电梯
     * @param openId
     * @param elevatorId
     * @return
     */
    Boolean focusElevator(String openId, String elevatorId);

    /**
     * 取消关注电梯
     * @param openId
     * @param elevatorId
     * @return
     */
    Boolean cancelFocusElevator(String openId, String elevatorId);

    /**
     * 获取用户关注电梯列表
     * @param openId
     * @return
     */
    List<ElevatorListDto> getMyFocusElevator(String openId);
}
