package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class EquDefineConverter implements Converter<String> {

    private static final Map<String, String> equipmentMap = new HashMap<>();
    public static final Map<String, String> reverseEquipmentMap = new HashMap<>();
    static {
        // 填充映射关系
        equipmentMap.put("有机热载体气相炉", "1310");
        equipmentMap.put("有机热载体液相炉", "1320");
        equipmentMap.put("超高压容器", "2110");
        equipmentMap.put("第三类压力容器", "2130");
        equipmentMap.put("第二类压力容器", "2150");
        equipmentMap.put("第一类压力容器", "2170");
        equipmentMap.put("铁路罐车", "2210");
        equipmentMap.put("汽车罐车", "2220");
        equipmentMap.put("长管拖车", "2230");
        equipmentMap.put("罐式集装箱", "2240");
        equipmentMap.put("管束式集装箱", "2250");
        equipmentMap.put("无缝气瓶", "2310");
        equipmentMap.put("焊接气瓶", "2320");
        equipmentMap.put("特种气瓶（内装填料气瓶、纤维缠绕气瓶、低温绝热气瓶）", "23T0");
        equipmentMap.put("医用氧舱", "2410");
        equipmentMap.put("高气压舱", "2420");
        equipmentMap.put("通用桥式起重机", "4110");
        equipmentMap.put("防爆桥式起重机", "4130");
        equipmentMap.put("绝缘桥式起重机", "4140");
        equipmentMap.put("冶金桥式起重机", "4150");
        equipmentMap.put("电动葫芦桥式起重机", "4190");
        equipmentMap.put("通用门式起重机", "4210");
        equipmentMap.put("防爆门式起重机", "4220");
        equipmentMap.put("轨道式集装箱门式起重机", "4230");
        equipmentMap.put("轮胎式集装箱门式起重机", "4240");
        equipmentMap.put("岸边集装箱起重机", "4250");
        equipmentMap.put("造船门式起重机", "4260");
        equipmentMap.put("电动葫芦门式起重机", "4270");
        equipmentMap.put("装卸桥", "4280");
        equipmentMap.put("架桥机", "4290");
        equipmentMap.put("普通塔式起重机", "4310");
        equipmentMap.put("电站塔式起重机", "4320");
        equipmentMap.put("轮胎起重机", "4410");
        equipmentMap.put("履带起重机", "4420");
        equipmentMap.put("集装箱正面吊运起重机", "4440");
        equipmentMap.put("铁路起重机", "4450");
        equipmentMap.put("门座起重机", "4710");
        equipmentMap.put("固定式起重机", "4760");
        equipmentMap.put("施工升降机", "4860");
        equipmentMap.put("简易升降机", "4870");
        equipmentMap.put("叉车", "5110");
        equipmentMap.put("峡谷漂流系列", "6D10");
        equipmentMap.put("水滑梯系列", "6D20");
        equipmentMap.put("碰碰船系列", "6D40");
        equipmentMap.put("蹦极系列", "6E10");
        equipmentMap.put("滑索系列", "6E20");
        equipmentMap.put("空中飞人系列", "6E30");
        equipmentMap.put("系留式观光气球系列", "6E40");
        equipmentMap.put("往复式客运架空索道", "9110");
        equipmentMap.put("循环式客运架空索道", "9120");
        equipmentMap.put("往复式客运缆车", "9210");
        equipmentMap.put("循环式客运缆车", "9220");
        equipmentMap.put("低位客运拖牵索道", "9310");
        equipmentMap.put("高位客运拖牵索道", "9320");
        equipmentMap.put("电动单梁起重机", "4170");
        equipmentMap.put("曳引驱动乘客电梯", "3110");
        equipmentMap.put("曳引驱动载货电梯", "3120");
        equipmentMap.put("强制驱动载货电梯", "3130");
        equipmentMap.put("液压乘客电梯", "3210");
        equipmentMap.put("液压载货电梯", "3220");
        equipmentMap.put("自动扶梯", "3310");
        equipmentMap.put("自动人行道", "3320");
        equipmentMap.put("防爆电梯", "3410");
        equipmentMap.put("消防员电梯", "3420");
        equipmentMap.put("杂物电梯", "3430");
        equipmentMap.put("输油管道", "8110");
        equipmentMap.put("输气管道", "8120");
        equipmentMap.put("燃气管道", "8210");
        equipmentMap.put("热力管道", "8220");
        equipmentMap.put("工艺管道", "8310");
        equipmentMap.put("动力管道", "8320");
        equipmentMap.put("制冷管道", "8330");
        equipmentMap.forEach((key, value) -> reverseEquipmentMap.put(value, key));
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return equipmentMap.getOrDefault(cellValue, null);
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }

    public static String getKeyByValue(String value) {
        for (Map.Entry<String, String> entry : equipmentMap.entrySet()) {
            if (entry.getValue().equals(value)) {
                return entry.getKey();
            }
        }
        return null;
    }
}
