package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.foundation.utils.TreeNode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 装备分类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_category")
@ApiModel(value="EquipmentCategory装备分类实体", description="装备分类")
public class EquipmentCategory extends BaseEntity implements TreeNode<EquipmentCategory, Long> {

    private static final long serialVersionUID = 1L;

    private Long parentId;

    @ApiModelProperty(value = "装备分类编码")
    private String code;

    @ApiModelProperty(value = "装备分类名称")
    private String name;

    @ApiModelProperty(value = "消耗性装备标志")
    private Boolean isConsumptive;

    @ApiModelProperty(value = "用途或性能")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "行业id")
    private String industryCode;

    // 此业务字段暂时不用，后期业务下发可放开
//    @ApiModelProperty(value = "装备二级分类图片")
//    private String img;

    @ApiModelProperty(value = "行业名称")
    @TableField(exist = false)
    private String industryName;
    
    @TableField(exist=false)
    @ApiModelProperty(value = "级别")
	private String level;

    @TableField(exist = false)
    @ApiModelProperty(value = "个数-巡检树用")
    private Integer patrolNum;

    @TableField(exist=false)
    @ApiModelProperty(value = "个数")
	private Double count;

    @ApiModelProperty(value = "类型(car:车辆 equipment：装备)")
    @TableField(exist=false)
    private String type;

    @TableField(exist=false)
    private boolean hasLowerClassification;      //是否存在下级
    
    @TableField(exist=false)
    private List<EquipmentCategory> children = new ArrayList<>(); //子集

    @Override
    public Long getMyParentId() {
        return parentId;
    }

    @Override
    public Long getMyId() {
        return getId();
    }

    @Override
    public void setChildren(Collection<EquipmentCategory> collection) {
        children = new ArrayList<>(collection);
    }

    @Override
    public int compareTo(EquipmentCategory o) {
        return getId().compareTo(o.getId());
    }
}
