package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 流水
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_journal")
@ApiModel(value = "Journal对象", description = "流水")
public class Journal extends BaseEntity {

	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "装备详情定义id")
	private Long equipmentDetailId;
	@ApiModelProperty(value = "仓库id")
	private Long warehouseStructureId;

	@ApiModelProperty(value = "操作状态，入库，出库，维修，保养，报废，借用，转移等。")
	private String state;

	@ApiModelProperty(value = "库存数量")
	private Double amount;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "库存详情id")
	private Long stockDetailId;

	@ApiModelProperty(value = "车辆id")
	private Long carId;

	@ApiModelProperty(value = "用户id")
	@TableField(value = "user_id", fill = FieldFill.INSERT)
	private Long userId;

	@ApiModelProperty(value = "用户名称")
	@TableField(value = "user_name", fill = FieldFill.INSERT)
	private String userName;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

}
