package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-电梯
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_elevator")
public class TechParamsElevatorChangeFieldDto extends BaseTechParamsFieldDto {

    @FieldDisplayDefine(value = "额定速度(上行)")
    private String ratedSpeedUp;

    @FieldDisplayDefine(value = "额定速度(下行)")
    private String ratedSpeedDown;

    @FieldDisplayDefine(value = "额定载重量")
    private String ratedLoadCapacity;

    @FieldDisplayDefine(value = "提升高度")
    private String liftingHeight;

    @FieldDisplayDefine(value = "层数")
    private Integer storey;

    @FieldDisplayDefine(value = "站数")
    private Integer stand;

    @FieldDisplayDefine(value = "门数")
    private Integer numberDoors;

    @FieldDisplayDefine(value = "控制方式", dictCode = "KZFS")
    private String controlMode;

    @FieldDisplayDefine(value = "油缸数量")
    private Integer numberCylinders;

    @FieldDisplayDefine(value = "顶升方式", dictCode = "DSXS")
    private String jackingType;


    @FieldDisplayDefine(value = "区域防爆等级", dictCode = "FBDJ")
    private String explosionproofGrade;


    @FieldDisplayDefine(value = "整机防爆标志")
    private String explosionproofSignComplete;


    @FieldDisplayDefine(value = "名义速度")
    private String nominalSpeed;

    @FieldDisplayDefine(value = "名义宽度")
    private String nominalWidth;


    @FieldDisplayDefine(value = "倾斜角")
    private String angleRoll;


    @FieldDisplayDefine(value = "使用区段长度")
    private String useSectionLength;


    @FieldDisplayDefine(value = "输送能力")
    private String conveyingCapacity;


    @FieldDisplayDefine(value = "轿门位置")
    private String doorPosition;


    @FieldDisplayDefine(value = "额定速度")
    private String ratedSpeed;
}
