package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.useRegister;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.common.api.enums.CylinderTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl.*;

/**
 * 使用登记-提醒处理器
 */
@Component
public class UseRegisterReminderAdapter extends DefaultReminder {

    private final UseRegisterReminderParse useRegisterReminderParse;

    public UseRegisterReminderAdapter(ApplicationContext applicationContext, UseRegisterReminderParse useRegisterReminderParse) {
        super(applicationContext);
        this.useRegisterReminderParse = useRegisterReminderParse;
    }

    @Override
    public List<ReminderItemDto> realtimeParse(String bizId) {
        List<ReminderItemDto> re = new ArrayList<>();
        //  创建后, 监管通过时使用
        JgUseRegistration useRegistration = useRegisterReminderParse.getJgUseRegistrationMapper().selectById(bizId);
        // 压力管道- 左侧设备类别以装置为维度
        if (StringUtils.isNotEmpty(useRegistration.getProjectContraptionId())) {
            String projectContraptionId = useRegistration.getProjectContraptionId();
            IdxBizJgProjectContraption projectContraption = useRegisterReminderParse.getIdxBizJgProjectContraptionServiceImpl().getById(projectContraptionId);
            ReminderItemDto reminderItemDto = new ReminderItemDto();
            reminderItemDto.setEquipId(projectContraptionId);
            reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
            reminderItemDto.setEquipName(projectContraption.getProjectContraption());
            reminderItemDto.setDetailData(this.buildProjectContraptionByStatus(useRegistration, useRegistration.getProjectContraptionId()));
            re.add(reminderItemDto);
        }
        // 气瓶-左侧以气瓶为维度
        if (StringUtils.isEmpty(useRegistration.getProjectContraptionId()) && "unit".equals(useRegistration.getManageType())) {
            LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
            lambda.eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr());
            lambda.select(JgUseRegistrationEq::getEquId);
            List<String> records = useRegisterReminderParse.getJgRelationEquipMapper().selectList(lambda).stream().map(JgUseRegistrationEq::getEquId).collect(Collectors.toList());
            Map<String, Object> historyData = getValuesFromHistory(useRegistration);
            List<ReminderItemDto> itemDtoList = useRegisterReminderParse.getJgUseRegistrationMapper().queryForUnitVehiclePageForReminder(records);
            itemDtoList.forEach(item -> item.setDetailData(this.buildSetUseDataByStatus(historyData, item.getEquipId())));
            re.addAll(itemDtoList);
        }
        // 台套设备
        if (StringUtils.isEmpty(useRegistration.getManageType()) || "set".equals(useRegistration.getManageType())) {
            LambdaQueryWrapper<JgUseRegistrationEq> lambda = new LambdaQueryWrapper<>();
            lambda.eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr());
            lambda.select(JgUseRegistrationEq::getEquId);
            List<JgUseRegistrationEq> eqList = useRegisterReminderParse.getJgRelationEquipMapper().selectList(lambda);
            String record = eqList.iterator().next().getEquId();
            ReminderItemDto reminderItemDto = new ReminderItemDto();
            IdxBizJgRegisterInfo registerInfo = useRegisterReminderParse.getIdxBizJgRegisterInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record)
                    .select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getProductName));
            IdxBizJgUseInfo idxBizJgUseInfo = useRegisterReminderParse.getIdxBizJgUseInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, record)
                    .select(IdxBizJgUseInfo::getRecord, IdxBizJgUseInfo::getUseInnerCode));
            reminderItemDto.setEquipId(record);
            reminderItemDto.setEquipNo(idxBizJgUseInfo.getUseInnerCode());
            reminderItemDto.setEquipName(registerInfo.getProductName());
            Map<String, Object> historyData = getValuesFromHistory(useRegistration);
            reminderItemDto.setDetailData(this.buildSetUseDataByStatus(historyData, record));
            re.add(reminderItemDto);
        }
        return re;
    }

    private Map<String, Object> buildSetUseDataByStatus(Map<String, Object> re, String record) {
        if (re != null) return re;
        return useRegisterReminderParse.getEquipDetailByRecord(record);
    }

    private Map<String, Object> buildProjectContraptionByStatus(JgUseRegistration useRegistration, String projectContraptionId) {
        Map<String, Object> re1 = getValuesFromHistory(useRegistration);
        if (re1 != null) return re1;
        Map<String, Object> re = BeanUtil.beanToMap(useRegistration);
        IdxBizJgProjectContraption projectContraption = useRegisterReminderParse.getIdxBizJgProjectContraptionServiceImpl().getById(projectContraptionId);
        re.putAll(BeanUtil.beanToMap(projectContraption));
        return re;
    }

    private Map<String, Object> getValuesFromHistory(JgUseRegistration useRegistration) {
        if (!useRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName())) {
            JSONObject his = useRegisterReminderParse.getJgCommonService().queryHistoryData(useRegistration.getSequenceNbr());
            Map<String, Object> re = new HashMap<>();
            re.putAll(his);
            re.putAll(BeanUtil.beanToMap(useRegistration));
            return re;
        }
        return null;
    }

    @Override
    public List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        List<ReminderItemDto> re = new ArrayList<>();
        JSONObject data = getSummitDataFromJson(formData);
        String manageType = data.getString("manageType");
        if (StringUtils.isNotEmpty(manageType) && "unit".equals(manageType)) { // 单位办理方式
            String equListCode = data.getString("EQU_LIST_CODE");
            // 气瓶--气瓶分页->调整为按照使用登记证维度（此处未修改，只是把规则表进行修改，防止后期又调整为按照气瓶进行缺项）
            if (CylinderTypeEnum.CYLINDER.getCode().equals(formData.get("EQU_CATEGORY_CODE"))) {
                List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) data.get("equipmentLists");
                List<String> records = equipmentLists.stream().map(item -> item.get("record").toString()).collect(Collectors.toList());
                List<ReminderItemDto> itemDtoList = useRegisterReminderParse.getJgUseRegistrationMapper().queryForUnitVehiclePageForReminder(records);
                itemDtoList.forEach(item -> {
                    item.setDetailData(data);
                });
                re.addAll(itemDtoList);
            }
            // 压力管道--装置
            if (EquipmentClassifityEnum.YLGD.getCode().equals(equListCode)) {
                String projectContraptionId = data.getString("projectContraptionId");
                IdxBizJgProjectContraption projectContraption = useRegisterReminderParse.getIdxBizJgProjectContraptionServiceImpl().getById(projectContraptionId);
                ReminderItemDto reminderItemDto = new ReminderItemDto();
                reminderItemDto.setEquipId(projectContraptionId);
                reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
                reminderItemDto.setEquipName(projectContraption.getProjectContraption());
                reminderItemDto.setDetailData(data);
                re.add(reminderItemDto);
            }
        } else {                                                             // 台套方式
            String record = data.getString("equipId");
            ReminderItemDto reminderItemDto = new ReminderItemDto();
            reminderItemDto.setEquipId(record);
            reminderItemDto.setEquipNo(data.getString("useInnerCode"));
            reminderItemDto.setEquipName(data.getString("productName"));
            reminderItemDto.setDetailData(data);
            re.add(reminderItemDto);
        }
        return re;
    }

    private static JSONObject getSummitDataFromJson(Map<String, Object> formData) {
        JSONObject data;
        //  新增 + 编辑的保存使用
        if (formData.containsKey(notice)) { // 新增登记工作台发起
            data = JSONObject.parseObject(JSONObject.toJSONString(formData.get(notice)));
            data.put("regType", "0");
        } else if (formData.containsKey(SECOND)) { // 历史有证、无证登记
            data = JSONObject.parseObject(JSONObject.toJSONString(formData.get(SECOND)));
            String regType = data.getString(KEY_REG_TYPE);
            data.put("regType", regType);
        } else {                                 //  编辑
            data = new JSONObject(formData);
        }
        return data;
    }

    @Override
    public MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        // 新增 + 编辑的保存并提交使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        JSONObject data = getSummitDataFromJson(formData);
        String manageType = data.getString("manageType");
        if (StringUtils.isNotEmpty(manageType) && "unit".equals(manageType)) { // 单位办理方式
            String equListCode = data.getString("EQU_LIST_CODE");
            // 气瓶--气瓶分页
            if (CylinderTypeEnum.CYLINDER.getCode().equals(formData.get("EQU_CATEGORY_CODE"))) {
                String record = CommonReminderService.getOneRecord(data);
                setMatchItemEquCategoryByRecord(matchItemDto, record);
                matchItemDto.setRegType(data.getString("regType"));
            }
            // 压力管道--装置
            if (EquipmentClassifityEnum.YLGD.getCode().equals(equListCode)) {
                String projectContraptionId = data.getString("projectContraptionId");
                IdxBizJgProjectContraption projectContraption = useRegisterReminderParse.getIdxBizJgProjectContraptionServiceImpl().getById(projectContraptionId);
                matchItemDto.setEquList(projectContraption.getEquList());
                matchItemDto.setEquCategory(projectContraption.getEquCategory());
                matchItemDto.setEquDefine(projectContraption.getEquDefine());
                matchItemDto.setRegType(data.getString("regType"));
            }
        } else {                                                             // 台套方式
            String record = data.getString("equipId");
            setMatchItemEquCategoryByRecord(matchItemDto, record);
            matchItemDto.setRegType(data.getString("regType"));
        }
        return matchItemDto;
    }

    private void setMatchItemEquCategoryByRecord(MatchItemDto matchItemDto, String record) {
        IdxBizJgRegisterInfo registerInfo = useRegisterReminderParse.getIdxBizJgRegisterInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record)
                .select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getEquList, IdxBizJgRegisterInfo::getEquCategory, IdxBizJgRegisterInfo::getEquDefine));
        matchItemDto.setEquList(registerInfo.getEquList());
        matchItemDto.setEquCategory(registerInfo.getEquCategory());
        matchItemDto.setEquDefine(registerInfo.getEquDefine());
    }

    @Override
    public MatchItemDto setMatchItem(String bizId) {
        // 评分 + 详情(通过按钮)使用
        JgUseRegistration useRegistration = useRegisterReminderParse.getJgUseRegistrationMapper().selectById(bizId);
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        matchItemDto.setRegType(StringUtils.isEmpty(useRegistration.getRegType()) ? "0" : useRegistration.getRegType());
        // 压力管道
        if (StringUtils.isNotEmpty(useRegistration.getProjectContraptionId())) {
            IdxBizJgProjectContraption projectContraption = useRegisterReminderParse.getIdxBizJgProjectContraptionServiceImpl().getById(useRegistration.getProjectContraptionId());
            matchItemDto.setEquList(projectContraption.getEquList());
            matchItemDto.setEquCategory(projectContraption.getEquCategory());
            matchItemDto.setEquDefine(projectContraption.getEquDefine());
        }
        // 气瓶
        if (StringUtils.isEmpty(useRegistration.getProjectContraptionId()) && "unit".equals(useRegistration.getManageType())) {
            setEquCategoryByOneRecord(useRegistration, matchItemDto);
        }
        // 台套设备
        if (StringUtils.isEmpty(useRegistration.getManageType()) || "set".equals(useRegistration.getManageType())) {
            setEquCategoryByOneRecord(useRegistration, matchItemDto);
        }
        return matchItemDto;
    }

    private void setEquCategoryByOneRecord(JgUseRegistration useRegistration, MatchItemDto matchItemDto) {
        LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        lambda.eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr());
        lambda.select(JgUseRegistrationEq::getEquId);
        List<JgUseRegistrationEq> eqList = useRegisterReminderParse.getJgRelationEquipMapper().selectList(lambda);
        String record = eqList.iterator().next().getEquId();
        setMatchItemEquCategoryByRecord(matchItemDto, record);
    }

    @Override
    public String supportBizType() {
        return BusinessTypeEnum.JG_USAGE_REGISTRATION.name();
    }
}
