package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.common.api.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.ExportDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TemplateExport;
import com.yeejoin.amos.boot.module.ymt.api.service.IMaintenanceUnitService;
import com.yeejoin.amos.boot.module.ymt.api.service.IRescueStationService;
import com.yeejoin.amos.boot.module.ymt.api.service.IUseUnitService;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.ElevatorServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.VoiceRecordFileServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.TemplateExportServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;
import com.yeejoin.amos.boot.module.ymt.api.dto.TemplateExportDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 模板表
 *
 * @author system_generator
 * @date 2021-10-25
 */
@RestController
@Api(tags = "导出Api")
@RequestMapping(value = "/template-export")
public class TemplateExportController extends BaseController {

    @Autowired
    TemplateExportServiceImpl templateExportServiceImpl;

	@Autowired
	IMaintenanceUnitService iMaintenanceUnitService;

	@Autowired
	IUseUnitService iUseUnitService;

	@Autowired
    ElevatorServiceImpl elevatorServiceImpl;

	@Autowired
	IRescueStationService iRescueStationService;

	@Autowired
    VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    /**
     * 新增模板表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增模板", notes = "新增模板")
	public ResponseModel<TemplateExportDto> save(@RequestBody TemplateExportDto model) {
		if (ValidationUtil.isEmpty(model.getTemplateName())
				|| ValidationUtil.isEmpty(model.getTemplateContent())
				|| ValidationUtil.isEmpty(model.getTemplateType())
		) {
			throw new BadRequest("参数校验失败.");
		}
		// 判断 同一类型模板名称不能重复
		TemplateExport temp = templateExportServiceImpl.getOne(new LambdaQueryWrapper<TemplateExport>().eq(TemplateExport::getIsDelete,0).eq(TemplateExport::getTemplateType,model.getTemplateType()).eq(TemplateExport::getTemplateName,model.getTemplateName()));
		if(temp != null) {
			throw new BadRequest("模板名称已存在.");
		}
		model.setIsStandard(false); // 新增模板表均不为标准模板
	    model = templateExportServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新模板", notes = "根据sequenceNbr更新模板")
	public ResponseModel<TemplateExportDto> updateBySequenceNbrTemplateExport(@RequestBody TemplateExportDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		if (ValidationUtil.isEmpty(model.getTemplateType())
		) {
			throw new BadRequest("模板类型为必填项");
		}
		if(StringUtils.isNotBlank(model.getTemplateName())) {
			TemplateExport temp = templateExportServiceImpl.getOne(new LambdaQueryWrapper<TemplateExport>().eq(TemplateExport::getTemplateType,model.getTemplateType()).
					eq(TemplateExport::getTemplateName,model.getTemplateName()).
					ne(TemplateExport::getSequenceNbr,sequenceNbr).
					eq(TemplateExport::getIsDelete,0));
			if(temp != null) {
				throw new BadRequest("模板名称已存在.");
			}
		}
		model.setIsStandard(false); // 更新模板表均不为标准模板
	    return ResponseHelper.buildResponse(templateExportServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除模板", notes = "根据sequenceNbr删除模板")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
    	// 不可删除标准模板
		TemplateExport temp = templateExportServiceImpl.getOne(new LambdaQueryWrapper<TemplateExport>().
				eq(TemplateExport::getSequenceNbr,sequenceNbr));
		if(temp.getIsStandard() == true) {
			throw new BadRequest("不可删除标准模板.");
		}


        return ResponseHelper.buildResponse(templateExportServiceImpl.update(new LambdaUpdateWrapper<TemplateExport>().set(TemplateExport::getIsDelete,true).eq(TemplateExport::getSequenceNbr,sequenceNbr)));
    }


	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "模板表列表全部数据查询",   notes = "模板表列表全部数据查询")
	@GetMapping(value = "/list/{type}")
	public ResponseModel<Map<String, Object>> selectForList(@PathVariable String type) {
		Map<String, Object> result = new HashMap<>();
		List<TemplateExport> list = templateExportServiceImpl.list(new LambdaQueryWrapper<TemplateExport>().eq(TemplateExport::getIsDelete,0).eq(TemplateExport::getTemplateType,type).orderByDesc(TemplateExport::getIsStandard));
		result.put("list",list);
		String fileName = null;
		if("ELEVATOR".equals(type)) { // 查询电梯数据
			fileName = "电梯信息";
		} else if("MAINTENANCE_COMPANY".equals(type)) { // 查询维保单位数据
			fileName = "维保单位";
		} else if("USE_UNIT".equals(type)) { // 查询使用单位数据
			fileName = "使用单位";
		} else if("RESCUE_STATION".equals(type)) { // 查询救援站数据
			fileName = "救援站";
		} else if("VOICE_RECORD".equals(type)) { // 查询通话录音数据
			fileName = "通话录音";
		}
		fileName += DateUtils.getDateNowShortNumber();
		result.put("fileName",fileName);
	    return ResponseHelper.buildResponse(result);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "根据字段类型导出", notes = "根据字段类型导出")
	@PostMapping("/exportByTypeParams")
	public void exportByTypeParams(@RequestBody ExportDto exportDto, HttpServletResponse response) {
		if (ValidationUtil.isEmpty(exportDto.getExportArray())
				|| ValidationUtil.isEmpty(exportDto.getDataType())
				|| ValidationUtil.isEmpty(exportDto.getFileName())
				|| ValidationUtil.isEmpty(exportDto.getExportType())
				|| ValidationUtil.isEmpty(exportDto.getFileType())
		) {
			throw new BadRequest("参数校验失败.");
		}
		// 导出模块 电梯  维保单位  救援机构
		if("1042".equals(exportDto.getDataType())) { // 选择列导出
			if(ValidationUtil.isEmpty(exportDto.getExportId())) {
				throw new BadRequest("未选择需要导出的数据.");
			}
		} else {
			exportDto.setExportId("");
		}
		JSONArray jsonArray = JSONArray.parseArray(exportDto.getExportArray());
		List<List<String>> heads = Lists.newArrayList();
		List<String> headstr = Lists.newArrayList();
		List list = null;
		String sheetName = null;
		for(int i = 0; i < jsonArray.size() ; i ++) {
			JSONObject temp = jsonArray.getJSONObject(i);
			headstr.add(temp.getString("key"));
			List<String> tempList = Lists.newArrayList(temp.getString("value"));
			heads.add(tempList);
		}
		String fileName = exportDto.getFileName();
		if("ELEVATOR".equals(exportDto.getExportType())) { // 查询电梯数据
			list = elevatorServiceImpl.selectExportData(exportDto.getExportId());
			sheetName = "电梯信息";
		} else if("MAINTENANCE_COMPANY".equals(exportDto.getExportType())) { // 查询维保单位数据
			list = iMaintenanceUnitService.selectExportData(exportDto.getExportId());
			sheetName = "维保单位";
		} else if("USE_UNIT".equals(exportDto.getExportType())) { // 查询使用单位数据
			sheetName = "使用单位";
			list = iUseUnitService.selectExportData(exportDto.getExportId());
		} else if("RESCUE_STATION".equals(exportDto.getExportType())) { // 查询救援站数据
			sheetName = "救援站";
			list = iRescueStationService.selectExportData(exportDto.getExportId());
		} else if("VOICE_RECORD".equals(exportDto.getExportType())) { // 查询救援站数据
			sheetName = "通话录音";
			list = voiceRecordFileServiceImpl.selectExportData(exportDto.getExportId());
		}
		ExcelUtil.createTemplateWithHeaders(response, fileName, sheetName, list, heads, headstr, exportDto.getFileType());

	}
}
