package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 改造告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Data
@EqualsAndHashCode (callSuper = true)
@ApiModel (value = "JgReformNoticeDto", description = "改造告知")
public class JgReformNoticeDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty (value = "申请编号")
    private String applyNo;

    @ApiModelProperty (value = "告知日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date noticeDate;

    @ApiModelProperty (value = "告知状态")
    private String noticeStatus;

    @ApiModelProperty(value = "告知状态描述")
    private String noticeStatusDesc;

    @ApiModelProperty (value = "施工单位统一信用代码")
    private String installUnitCreditCode;

    @ApiModelProperty (value = "施工单位名称")
    private String installUnitName;

    @ApiModelProperty (value = "设备数量")
    private Integer equipNum;

    @ApiModelProperty (value = "流程实例id")
    private String instanceId;

    @ApiModelProperty (value = "下步执行角色/人id")
    private String nextExecutorId;

    @ApiModelProperty (value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty (value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty (value = "创建人id ")
    private String createUserId;

    @ApiModelProperty (value = "创建人")
    private String createUserName;

    @ApiModelProperty (value = "备注")
    private String remark;

    @ApiModelProperty (value = "流程状态")
    private String instanceStatus;

    @ApiModelProperty (value = "受理完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date acceptDate;

    @ApiModelProperty (value = "施工区域-省")
    private String province;

    @ApiModelProperty (value = "施工区域-市")
    private String city;

    @ApiModelProperty (value = "施工区域-区/县")
    private String county;

    @ApiModelProperty (value = "施工区域-街道（镇）")
    private String street;

    @ApiModelProperty (value = "施工设备详细地址")
    private String address;

    @ApiModelProperty (value = "计划施工日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date planDate;

    @ApiModelProperty (value = "接收机构单位代码")
    private String receiveCompanyCode;

    @ApiModelProperty (value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty (value = "施工负责人")
    private String constructionManager;

    @ApiModelProperty (value = "施工负责人id")
    private String constructionManagerId;

    @ApiModelProperty (value = "施工负责人手机")
    private String constructionManagerPhone;

    @ApiModelProperty (value = "检验单位统一信用代码")
    private String inspectionUnitCreditCode;

    @ApiModelProperty (value = "检验单位名称")
    private String inspectionUnitName;

    @ApiModelProperty (value = "委托单位统一信用代码")
    private String entrustingUnitCreditCode;

    @ApiModelProperty (value = "委托单位名称")
    private String entrustingUnitName;

    @ApiModelProperty (value = "委托书附件")
    private List<JSONObject> powerOfAttorney;

    @ApiModelProperty (value = "施工合同附件")
    private List<JSONObject> constructionContract;

    @ApiModelProperty (value = "施工合同是否本单位与甲方直接签署")
    private String isSignedWithA;

    @ApiModelProperty (value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty (value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty (value = "是否已报检")
    private String isInspected;

    @ApiModelProperty (value = "接收机构机构代码")
    private String receiveOrgCode;

    @ApiModelProperty (value = "是否西咸")
    private String isXixian;

    @ApiModelProperty(value = "设备种类code")
    private String equListCode;

    @ApiModelProperty(value = "设备种类名称")
    private String equListName;

    @ApiModelProperty(value = "设备类别code")
    private String equCategoryCode;

    @ApiModelProperty(value = "设备类别名称")
    private String equCategoryName;

    @ApiModelProperty(value = "工程装置名称")
    private String projectContraption;


    @ApiModelProperty(value = "工程装置id")
    private String projectContraptionId;

    /* ----------------  -------------- */

    @ApiModelProperty (value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @ApiModelProperty (value = "区名字")
    private String countyName;

    @ApiModelProperty (value = "市名字")
    private String cityName;

    @ApiModelProperty (value = "省名字")
    private String provinceName;

    public String getFullAddress() {
        return (StringUtils.isEmpty(this.provinceName) ? "" : this.provinceName)
                + (StringUtils.isEmpty(this.cityName) ? "" : this.cityName)
                + (StringUtils.isEmpty(this.countyName) ? "" : this.countyName)
                + (StringUtils.isEmpty(this.address) ? "" : this.address);
    }

    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    private String factoryUseSiteStreet;

    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    private String streetName;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "发起人id用于撤回操作")
    private String promoter;

    @ApiModelProperty(value = "告知单PDF URL")
    private String noticeReportUrl;

    private List<String> roleIds;

    private  String dataType  ;

    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 设备监管码
     */
    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    /**
     * 设备代码
     */
    @ApiModelProperty(value = "设备代码")
    private String equCode;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型")
    private String equList;

    /**
     * 设备品种
     */
    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    /**
     * 告知书编号
     */
    @ApiModelProperty(value = "告知书编号")
    private String informNumber;

    /**
     * 电梯96333码
     */
    @ApiModelProperty(value = "电梯96333码")
    private String code96333;

    /**
     * 下一节点可执行人逗号分割
     */
    @ApiModelProperty(value = "下一节点可执行人逗号分割-数据隔离使用")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "转办人")
    private String  transferToUserIds;

    @ApiModelProperty (value = "其他附件")
    private List<JSONObject> otherAccessories;


    /**
     *工作流下一节点任务id
     */
    @ApiModelProperty (value = "工作流下一节点任务id")
    private String nextTaskId;


    @ApiModelProperty("作废原因")
    private String cancelReason;

    @ApiModelProperty("作废日期")
    private Date cancelDate;

    @ApiModelProperty("作废人员id")
    private String cancelUserId;

    @ApiModelProperty("管道改造的长度变化值（正值为增加，负值为减少）-压力管道用")
    private String pipeLengthChanged;
}
