package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jyjc.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jyjc.biz.service.ICmWorkflowService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.FlowTaskVo;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class CmWorkflowServiceImpl implements ICmWorkflowService {

    @Override
    public List<ProcessTaskDTO> startBatch(ActWorkflowBatchDTO params) {
        List<ProcessTaskDTO> processTasks;
        try {
            log.info("开始请求工作流启动接口:/start/batch,请求参数：{}", JSONObject.toJSONString(params));
            processTasks = Workflow.taskV2Client.startForBatch(params).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = e.getDevMessage();
            devMessage = devMessage.contains(";") ? devMessage.split(";")[0] : devMessage;
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流批量启动失败", e);
            throw new RuntimeException("调用工作流批量启动失败");
        }
        return processTasks;
    }

    @Override
    public ProcessTaskDTO complete(String taskId, TaskResultDTO data) {
        ProcessTaskDTO processTaskDTO;
        try {
            log.info("开始请求工作流完成任务接口:/complete/standard/{taskId},请求参数：{},{}", taskId, JSONObject.toJSONString(data));
            processTaskDTO = Workflow.taskV2Client.completeByTaskFroStandard(taskId, data).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = e.getDevMessage();
            devMessage = devMessage.contains(";") ? devMessage.split(";")[0] : devMessage;
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流完成任务接口失败", e);
            throw new RuntimeException("调用工作流完成任务接口失败");
        }
        return processTaskDTO;
    }

    @Override
    public ProcessTaskDTO reject(String taskId, TaskResultDTO data) {
        ProcessTaskDTO processTaskDTO;
        try {
            log.info("开始请求工作流完成任务接口:/complete/standard/{taskId},请求参数：{},{}", taskId, JSONObject.toJSONString(data));
            processTaskDTO = Workflow.taskV2Client.reject(taskId, data).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = e.getDevMessage();
            devMessage = devMessage.contains(";") ? devMessage.split(";")[0] : devMessage;
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流完成任务接口失败", e);
            throw new RuntimeException("调用工作流完成任务接口失败");
        }
        return processTaskDTO;
    }
    @Override
    public ProcessTaskDTO rollBack(String processInstanceId) {
        log.info("开始请求工作流撤回接口:/rollBack/standard/{processInstanceId},请求参数：{}", processInstanceId);
        return FeignUtil.remoteCall(() -> Workflow.taskV2Client.rollBackTask(processInstanceId));
    }

    @Override
    public ProcessTaskDTO assign(FlowTaskVo taskVo) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        try {
            log.info("开始请求工作流转办任务接口:/assign/{taskVo},请求参数：{},{}", taskVo);
            processTaskDTO = Workflow.taskV2Client.assign(taskVo).getResult();
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = e.getDevMessage();
            devMessage = devMessage.contains(";") ? devMessage.split(";")[0] : devMessage;
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流转办任务接口失败", e);
            throw new RuntimeException("调用工作流转办任务接口失败");
        }
        return processTaskDTO;
    }
}
