package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.entity.FeedbackReplies;
import com.yeejoin.amos.boot.module.common.api.entity.FeedbackSuggestions;
import com.yeejoin.amos.boot.module.common.api.mapper.FeedbackRepliesMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFeedbackRepliesService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * 反馈回复表服务实现类
 *
 * @author system_generator
 * @date 2025-05-15
 */
@Service
public class FeedbackRepliesServiceImpl extends BaseService<FeedbackReplies, FeedbackReplies, FeedbackRepliesMapper> implements IFeedbackRepliesService {
    /**
     * 分页查询
     */
    public Page<FeedbackReplies> queryForFeedbackRepliesPage(Page<FeedbackReplies> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FeedbackReplies> queryForFeedbackRepliesList() {
        return this.queryForList("", false);
    }

    @Autowired
    FeedbackSuggestionsServiceImpl feedbackSuggestionsServiceImpl;

    /**
     * 根据反馈建议表sequenceNbr查询回复列表
     *
     * @param suggestSeq 反馈建议表sequenceNbr
     * @return result
     */
    public List<FeedbackReplies> getRepliesListBySugSeq(Long suggestSeq) {
        return this.lambdaQuery()
                .eq(FeedbackReplies::getSuggestionsSeq, suggestSeq)
                .eq(FeedbackReplies::getIsDelete, Boolean.FALSE)
                .orderByDesc(FeedbackReplies::getCreateDate)
                .list();
    }

    public FeedbackReplies saveReplies(ReginParams reginParams, FeedbackReplies feedbackReplies) {
        CompanyBo company = reginParams.getCompany();
        AgencyUserModel userModel = reginParams.getUserModel();
        feedbackReplies.setCreateUserId(userModel.getUserId());
        feedbackReplies.setCreateUserName(userModel.getRealName());
        feedbackReplies.setCreateDate(new Date());
        feedbackReplies.setReplyUserId(userModel.getUserId());
        feedbackReplies.setReplyUserName(userModel.getRealName());
        feedbackReplies.setReadStatus("0");
        feedbackReplies.setReplyCompanyCode(company.getCompanyCode());
        feedbackReplies.setReplyCompanyName(company.getCompanyName());
        this.save(feedbackReplies);
        feedbackSuggestionsServiceImpl.lambdaUpdate()
                .eq(FeedbackSuggestions::getSequenceNbr, feedbackReplies.getSuggestionsSeq())
                .set(FeedbackSuggestions::getStatus, "1")
                .update();
        feedbackSuggestionsServiceImpl.sendMsg(feedbackSuggestionsServiceImpl.lambdaQuery().eq(FeedbackSuggestions::getSequenceNbr, feedbackReplies.getSuggestionsSeq()).one());
        return feedbackReplies;
    }
}