package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgRegisterInfoService;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 设备注册
 *
 * @author Provence
 * @version v1.0
 * @date 2023/12/13 14:37
 */
@RestController
@Api(tags = "设备注册Api")
@RequestMapping(value = "/equipment-register")
public class IdxBizJqEquipmentRegisterController extends BaseController {
    @Autowired
    IIdxBizJgRegisterInfoService idxBizJgRegisterInfoService;

    /**
     * 设备注册和更新信息
     *
     * @param paramMap
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/submit")
    @ApiOperation(httpMethod = "POST", value = "设备注册和更新信息", notes = "设备注册和更新信息")
    public ResponseModel<Object> submit(@RequestBody Map<String, Object> paramMap) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.equipmentRegisterSubmit(paramMap));
    }


    /**
     * 根据recordList批量删除设备注册信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除设备注册信息", notes = "批量删除设备注册信息")
    public ResponseModel<Boolean> deleteByRecordList(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.batchDeleteByRecord(map));
    }

    /**
     * 查询设备注册信息详情
     *
     * @param record
     * @return 返回由页签的key包裹详情对象
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{record}")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情", notes = "根据record查询设备注册信息详情")
    public ResponseModel<Object> selectOne(@PathVariable String record, @RequestParam(required = false) String isCopy) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getEquipmentRegisterByRecord(record, isCopy));
    }


    /**
     * 查询设备注册信息详情
     *
     * @param record
     * @return 只返回详情对象
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情", notes = "根据record查询设备注册信息详情")
    public ResponseModel<Map<String, Object>> getDetail(@RequestParam String record) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getDetailByRecord(record));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detailFieldCamelCase")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情，返回字段驼峰命名", notes = "根据record查询设备注册信息详情，返回字段驼峰命名")
    public ResponseModel<Map<String, Object>> getDetailFieldCamelCase(@RequestParam String record) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(record));
    }

    /**
     * 查询设备注册列表
     *
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "设备注册信息分页查询", notes = "设备注册信息分页查询")
    public ResponseModel<Page<JSONObject>> queryForPage(@RequestParam Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.queryForEquipmentRegisterPage(jsonObject));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/category/list")
    @ApiOperation(httpMethod = "GET", value = "查询不同单位类型可新增的设备种类列表", notes = "查询不同单位类型可新增的设备种类列表")
    public ResponseModel<List<DictionarieValueModel>> equCategoryListByCompanyType() {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.equCategoryListByCompanyType(getSelectedOrgInfo(), null));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equ-category/listByPersonAndEquList")
    @ApiOperation(httpMethod = "GET", value = "按照人员身份、设备种类查询设备类别", notes = "按照人员身份、设备种类查询设备类别")
    public ResponseModel<List<DictionarieValueModel>> equCategoryList(@RequestParam(value = "equList") String equList) {
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.equCategoryListByCompanyType(getSelectedOrgInfo(), equList));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equip/page")
    @ApiOperation(httpMethod = "GET", value = "单位办理设备列表查询", notes = "单位办理设备列表查询")
    public ResponseModel<Page<JSONObject>> queryEquipPage(@RequestParam Map<String, Object> queryMap) {
        JSONObject jsonObject = new JSONObject(queryMap);
        return ResponseHelper.buildResponse(idxBizJgRegisterInfoService.queryForUnitEquipmentPage(jsonObject));
    }
}
