package com.yeejoin.equipmanage.common.enums;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public enum PressurePumpEnum {
    ALONE_START_YXSC("FHS_PressurePump_Start_ALONE_START_YXSC","", new Date().getSeconds()+" " + new Date().getMinutes() +"/5 * * * ?", "5",
            PressurePumpValueEnum.PUMP_START_TIME.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getCode()),
    ALONE_START_QT("FHS_PressurePump_Start_ALONE_START_QT", PressurePumpCheckEnum.LE.getCode(), "", "5",
        PressurePumpValueEnum.LAST_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode()),
    ALONE_STOP_QT("FHS_PressurePump_Stop_ALONE_STOP_QT", PressurePumpCheckEnum.GE.getCode(), "5", "",
             PressurePumpValueEnum.LAST_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getCode()),
    ALL_START_QT_WJ("FHS_PressurePump_Start_ALL_START_QT_WJ", PressurePumpCheckEnum.LE.getCode(), "", "30",
            PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode()),
    ALL_START_QT_YZ("FHS_PressurePump_Start_ALL_START_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
             PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode()),
    ALL_START_QT_YB("FHS_PressurePump_Start_ALL_START_QT_YB", PressurePumpCheckEnum.BE.getCode(), "60", "240",
            PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YB.getCode()),
    ALL_STOP_QT_WJ("FHS_PressurePump_Stop_ALL_STOP_QT_WJ", PressurePumpCheckEnum.LE.getCode(), "", "30",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode()),
    ALL_STOP_QT_YZ("FHS_PressurePump_Stop_ALL_STOP_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode()),
    ALL_STOP_QT_YB("FHS_PressurePump_Stop_ALL_STOP_QT_YB", PressurePumpCheckEnum.BE.getCode(), "60", "240",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YB.getCode());

    private String code;
    private String operator;
    private String leftValue;
    private String rightValue;
    private String compareValue;
    private String level;

    private PressurePumpEnum(String code, String operator, String leftValue, String rightValue, String compareValue, String level) {
        this.code = code;
        this.operator = operator;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.compareValue = compareValue;
        this.level = level;
    }

    public static List<PressurePumpEnum> getEnumListByCode(String code) {
        List<PressurePumpEnum> list = new ArrayList<>();
        for(PressurePumpEnum e : PressurePumpEnum.values()) {
            if (e.getCode().startsWith(code)) {
                list.add(e);
            }
        }
        return list;
    }

    public String getCode() {
        return code;
    }
    public String getOperator() {
        return operator;
    }
    public String getLeftValue() {
        return leftValue;
    }
    public String getRightValue() {
        return rightValue;
    }
    public String getCompareValue() { return compareValue; }
    public String getLevel() { return level; }
}
