package com.yeejoin.equipmanage.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.*;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import com.yeejoin.equipmanage.service.ISupervisionVideoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "监盘总览组态需求 -- API")
@RequestMapping(value = "/supervisionConfigure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SupervisionConfigureController extends AbstractBaseController {

    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @Autowired
    private IEquipmentSpecificAlarmService equipmentSpecificAlarmService;

    @Autowired
    private IotFeign iotFeign;

    @Autowired
    private ISupervisionVideoService supervisionVideoService;

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览水源信息")
    @GetMapping("/getWaterInfo")
    public ResponseModel getWaterInfo(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getWaterInfoBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览泡沫罐和水箱信息（监盘概览）")
    @GetMapping("/getFoamTankBySuper")
    public ResponseModel getFoamTankBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getFoamTankBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览管网压力信息（监盘概览）")
    @GetMapping("/getPipeNetworkBySuper")
    public ResponseModel getPipeNetworkBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getPipeNetworkBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览水池装置进水流量信息（监盘概览）")
    @GetMapping("/getInfluentFlowBySuper")
    public ResponseModel getInfluentFlowBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getInfluentFlowBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取某站下装备数量、摄像头数量（监盘概览）")
    @GetMapping("/statisticsBySuper")
    public ResponseModel statisticsByStation(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(fireFightingSystemMapper.statisticsByStation(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "【监盘总览-排油系统信息】获取系统设备状态（根据系统编码查询）")
    @GetMapping("/getEquipmentStateBySuper")
    public ResponseModel getEquipmentStateBySuper(@RequestParam(required = false) String systemCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page result = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        } else {
            throw new BadRequest("系统编码不能为空");
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipmentStateBySuper(result, hashMap));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "【监盘总览-排油系统信息】获取系统工作状态（根据系统编码查询）")
    @GetMapping("/getSystemStatusBySuper")
    public ResponseModel getSystemStatusBySuper(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        } else {
            throw new BadRequest("系统编码不能为空");
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemStatusBySuper(hashMap));
    }


    @PersonIdentify
    @RequestMapping(value = "/fireAlarmLogPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防报警列表分页查询", produces = "application/json;charset=UTF-8", notes = "消防报警列表分页查询")
    public ResponseModel pageQuery(@RequestParam(required = false) String code, @RequestParam(required = false) String typeCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request7 = new CommonRequest();
        request7.setName("system");
        request7.setValue(StringUtil.isNotEmpty(code) ? StringUtils.trimToNull(code) : null);
        queryRequests.add(request7);
        CommonRequest request8 = new CommonRequest();
        request8.setName("specificIndexKey");
        request8.setValue(StringUtil.isNotEmpty(typeCode) ? StringUtils.trimToNull(typeCode) : null);
        queryRequests.add(request8);
        if (!ValidationUtil.isEmpty(reginParams.getPersonIdentity())) {
            CommonRequest request13 = new CommonRequest();
            request13.setName("bizOrgCode");
            request13.setValue(StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null);
            queryRequests.add(request13);
        }
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        return CommonResponseUtil.success(equipmentSpecificAlarmService.fireAlarmLogPage(param));
    }


    @PersonIdentify
    @RequestMapping(value = "/alarmTrend", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "报警类型趋势", produces = "application/json;charset=UTF-8", notes = "报警类型趋势")
    public ResponseModel alarmTrend() {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.alarmTrend(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览稳压泵信息")
    @GetMapping("/getPressurePumpInfo")
    public ResponseModel getPressurePumpInfo(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page<Map<String, Object>> pressurePumpInfo = fireFightingSystemMapper.getPressurePumpInfo(page, bizOrgCode, null);
        List<Long> ids = new ArrayList();
        pressurePumpInfo.getRecords().stream().map(item -> {
            item.put("monthStartNum", 0);
            item.put("halfHourStartNum", 0);
            item.put("twoHourStartNum", 0);
            item.put("fourHourStartNum", 0);
            item.put("update_time", "--");
            item.put("equipment_index_name", "--");
            String prefix = null;
            String suffix = null;
            String iotCode = item.get("iot_code").toString();
            if (iotCode.length() > 8) {
                prefix = iotCode.substring(0, 8);
                suffix = iotCode.substring(8);
            } else {
                throw new BadRequest("装备物联编码错误，请确认！");
            }

            String nowStrLong = DateUtils.getNowStrLong();
            Date mounthDate = null;
            try {
                mounthDate = DateUtils.getCurrentMonthStartTime(new Date());
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            Date halfHour = DateUtils.dateAddMinutes(null, -30);
            Date twoHour = DateUtils.dateAddHours(null, -2);
            Date fourHour = DateUtils.dateAddHours(null, -4);
            String startDateStr = DateUtils.convertDateToString(mounthDate, DateUtils.DATE_TIME_PATTERN);
            String half = DateUtils.convertDateToString(halfHour, DateUtils.DATE_TIME_PATTERN);
            String two = DateUtils.convertDateToString(twoHour, DateUtils.DATE_TIME_PATTERN);
            String four = DateUtils.convertDateToString(fourHour, DateUtils.DATE_TIME_PATTERN);
            ResponseModel mounthEntity = null;
            ResponseModel halfHourEntity = null;
            ResponseModel twoHourEntity = null;
            ResponseModel fourHourEntity = null;
            try {
                mounthEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
                halfHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), half, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
                twoHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), two, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
                fourHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), four, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (200 == mounthEntity.getStatus()) {
                String json1 = JSON.toJSONString(mounthEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("monthStartNum", num);
            }
            if (200 == halfHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(halfHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("halfHourStartNum", num);
            }
            if (200 == twoHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(twoHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("twoHourStartNum", num);
            }
            if (200 == fourHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(fourHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("fourHourStartNum", num);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long nowDateTime = new Date().getTime();//当前时间戳
            Map<String, String> stateMap = fireFightingSystemMapper.queryPressureNowStateBySpecificId((Long) item.get("id"));
            ids.add((Long) item.get("id"));
            boolean time = false;
            if (!ObjectUtils.isEmpty(stateMap) && stateMap.containsKey("update_date") && stateMap.containsKey("equipment_index_name")) {
                item.put("update_time", String.valueOf(stateMap.get("update_date")).replaceAll("T", " "));
                if(!ObjectUtils.isEmpty(stateMap.get("value"))){
                    item.put("equipment_index_name", stateMap.get("equipment_index_name"));
                } else {
                    item.put("equipment_index_name", "无信号");
                }
                if ("启动".equals(stateMap.get("equipment_index_name"))) {
                    long update_time = 0L;
                    try {
                        update_time = sdf.parse(String.valueOf(stateMap.get("update_date")).replaceAll("T", " ")).getTime();
                    } catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    long res = nowDateTime - update_time;
                    long diffMinute = res / 1000 / 60;
                    if (diffMinute <= 5) {
                        time = true;
                    }
                    item.put("upTime", diffMinute);
                }
            }
            item.put("stateDesc", Integer.parseInt(String.valueOf(item.get("isAlarm"))) == 0 || time ? "正常" : "异常");
            return item;
        }).collect(Collectors.toList());
        List<Map<String, Object>> stateMap = fireFightingSystemMapper.queryStartAndStopBySpecificId(ids);
        long diffMinute = 0L;
        if (!ObjectUtils.isEmpty(stateMap)) {
            String startTime = stateMap.get(0).get("update_date").toString();
            String endTime = stateMap.get(1).get("update_date").toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long start = 0L;
            long end = 0L;
            try {
                start = sdf.parse(startTime.replaceAll("T", " ")).getTime();
                end = sdf.parse(endTime.replaceAll("T", " ")).getTime();
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
            long res = start - end;
            diffMinute = res / 1000 / 60;
        }
        long finalDiffMinute = diffMinute;
        pressurePumpInfo.getRecords().stream(
        ).map(item -> {
            item.put("startAndStopInterval", finalDiffMinute);
            return item;
        }).collect(Collectors.toList());
        return CommonResponseUtil.success(pressurePumpInfo);
    }

    @PersonIdentify
    @RequestMapping(value = "/replaceVideo", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "替换视频", produces = "application/json;charset=UTF-8", notes = "替换视频")
    public ResponseModel replaceVideo(@RequestBody Map<String, String> ids) {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.replaceVideo(ids, bizOrgCode));
    }

    @PersonIdentify
    @RequestMapping(value = "/queryVideoList", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询视频列表", produces = "application/json;charset=UTF-8", notes = "查询视频列表")
    public ResponseModel queryVideoList() {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            if (personIdentity.getCompanyBizOrgCode() == null) {
                bizOrgCode = personIdentity.getBizOrgCode();
            } else {
                bizOrgCode = personIdentity.getCompanyBizOrgCode();
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.queryVideoList(bizOrgCode));
    }

    @PersonIdentify
    @RequestMapping(value = "/queryVideoAllId", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询对应站下所有视频id", produces = "application/json;charset=UTF-8", notes = "根据id查询视频")
    public ResponseModel queryVideoAllId() {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.queryVideoAllId(bizOrgCode));
    }

}
