package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.netflix.discovery.converters.Auto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.entity.ModelItem;
import com.yeejoin.amos.boot.module.tdc.api.entity.SubmitRecord;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckResultMapper;
import com.yeejoin.amos.boot.module.tdc.api.mapper.ModelItemMapper;
import com.yeejoin.amos.boot.module.tdc.api.mapper.SubmitRecordMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.ModelItemService;
import com.yeejoin.amos.boot.module.tdc.api.service.SubmitRecordService;
import com.yeejoin.amos.boot.module.tdc.api.service.SyncMethodService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class ModelItemServiceImpl extends ServiceImpl<ModelItemMapper, ModelItem> implements ModelItemService {

    @Autowired
    SubmitRecordService submitRecordService;

    @Autowired
    SyncMethodService syncMethodService;

    @Autowired
    CheckResultMapper checkResultMapper;

    @Autowired
    SubmitRecordMapper submitRecordMapper;

    @Autowired
    ModelItemMapper modelItemMapper;

    @Override
    public void saveModelItem(JSONObject jsonObject, AgencyUserModel userInfo) {
        long start = System.currentTimeMillis();
        if (ObjectUtils.isEmpty(jsonObject)) {
            return;
        }
        SubmitRecord submitRecord = new SubmitRecord();
        userInfo.getUserName();

        List<CompanyModel> company = userInfo.getCompanys();
        if (!CollectionUtils.isEmpty(company)) {
            String companyName = company.get(0).getCompanyName();
            String orgCode = company.get(0).getOrgCode();
            submitRecord.setAmosOrgCode(orgCode);
            submitRecord.setAmosOrgName(companyName);
        }
        submitRecord.setSubmitPeople(userInfo.getRealName());
        submitRecord.setSubmitTime(new Date());
        String batchNo = UUID.randomUUID().toString();
        submitRecord.setBatchNo(batchNo);
        long start1 = System.currentTimeMillis();
        log.error("=====记录入库前用时："+(start1-start)+"======");
        submitRecordService.saveSubmitRecord(submitRecord);
        long end = System.currentTimeMillis();
        log.error("=====记录入库用时："+(end-start1)+"======");
        if (StringUtils.isEmpty(submitRecord.getSequenceNbr())) {
            return;
        }

        List<ModelItem> collect = jsonObject.entrySet().stream().map(e -> {
            ModelItem modelItem = new ModelItem();
            String key = e.getKey();
            String[] s = key.split("_");
            if (s.length > 0) {
                modelItem.setModelName(s[0]);
                modelItem.setCheckItemLabel(s[1]);
            }
            String value = String.valueOf(e.getValue());
            modelItem.setCheckItemValue(value);
            modelItem.setSubmitRecordId(submitRecord.getSequenceNbr());
            return modelItem;
        }).collect(Collectors.toList());

        Map<String, List<ModelItem>> itemValue = collect.stream().collect(Collectors.groupingBy(ModelItem::getModelName));

        long e1 = System.currentTimeMillis();
        log.error("=====参数解析用时："+(e1-end)+"======");
         this.saveBatch(collect);
        long e2 = System.currentTimeMillis();
        log.error("=====入库用时："+(e2-e1)+"======");

        // 异步请求规则校验
        syncMethodService.checkItem(itemValue, submitRecord);
    }

    @Override
    public void editModelItem(JSONObject jsonObject, AgencyUserModel userInfo) {

        Long sequenceNbr = Long.valueOf(String.valueOf(jsonObject.get("sequenceNbr")));
        String batchNo = UUID.randomUUID().toString();
        SubmitRecord submitRecord = submitRecordService.updateById(sequenceNbr, batchNo);

        LambdaQueryWrapper<ModelItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ModelItem::getSubmitRecordId, sequenceNbr);
        this.baseMapper.delete(wrapper);

        List<ModelItem> collect = jsonObject.entrySet().stream().map(e -> {
            ModelItem modelItem = new ModelItem();
            String key = e.getKey();
            String[] s = key.split("_");
            if (s.length > 1) {
                modelItem.setModelName(s[0]);
                modelItem.setCheckItemLabel(s[1]);
                String value = String.valueOf(e.getValue());
                modelItem.setCheckItemValue(value);
                modelItem.setSubmitRecordId(submitRecord.getSequenceNbr());
                return modelItem;
            } else {
                return null;
            }
        }).filter(item -> !ObjectUtils.isEmpty(item)).collect(Collectors.toList());
        this.saveOrUpdateBatch(collect);

        // 异步请求规则校验
        Map<String, List<ModelItem>> itemValue = collect.stream().collect(Collectors.groupingBy(ModelItem::getModelName));
        syncMethodService.checkItem(itemValue, submitRecord);
    }


    @Override
    public Map<String, Object> getModelItem(Long sequenceNbr) {
        LambdaQueryWrapper<ModelItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ModelItem::getSubmitRecordId, sequenceNbr);
        List<ModelItem> list = this.list(wrapper);
        Map<String, Object> map = list.stream().collect(Collectors.toMap(e -> e.getModelName() + "_" + e.getCheckItemLabel(), ModelItem::getCheckItemValue));
        map.put("sequenceNbr", sequenceNbr);
        return map;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteModelItem(String sequenceNbr) {
        if (!StringUtils.isEmpty(sequenceNbr)) {
            String[] split = sequenceNbr.split(",");
            List<String> list = Arrays.asList(split);
            // 1. 删除记录
            submitRecordMapper.deleteBatchIds(list);
            // 2. 删除填报项
            LambdaQueryWrapper<ModelItem> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(ModelItem::getSubmitRecordId, list);
            this.baseMapper.delete(wrapper);
            // 3. 删除校验记录
            LambdaQueryWrapper<CheckResult> resultWrapper = new LambdaQueryWrapper<>();
            resultWrapper.in(CheckResult::getSubmitRecordId, list);
            checkResultMapper.delete(resultWrapper);
        }
    }
}
