package com.yeejoin.amos.fas.business.action.websocket;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CopyOnWriteArraySet;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
/**
 * 
 * <pre>
 * rule webSocket定义
 * </pre>
 *
 * @author amos
 * @version $Id: RuleWebSocket.java, v 0.1 2019年5月20日 下午4:59:50 amos Exp $
 */
@Component
@ServerEndpoint(value = "/rule.ws")
public class RuleWebSocket implements Observer
{
	private final static Logger log = LoggerFactory.getLogger(RuleWebSocket.class);
	// 静态变量，用来记录当前在线连接数。应该把它设计成线程安全的。
	private static int onlineCount = 0;

	// concurrent包的线程安全Set，用来存放每个客户端对应的MyWebSocket对象。
	private static CopyOnWriteArraySet<RuleWebSocket> webSocketSet = new CopyOnWriteArraySet<RuleWebSocket>();

	// 与某个客户端的连接会话，需要通过它来给客户端发送数据
	private Session session;

	private Observable ob;
	private String name;

	/**
	 * 连接建立成功调用的方法
	 */
	@OnOpen
	public void onOpen(Session session)
	{
		this.session = session;
		webSocketSet.add(this); // 加入set中
		addOnlineCount(); // 在线数加1
		log.debug("有新连接加入！当前在线人数为" + getOnlineCount());
		subscribeTopics(session);
	}

	/**
	 * 
	 * <pre>
	 * 订阅指挥
	 * </pre>
	 *
	 */
	public void subscribeTopics(Session session)
	{
//		this.ob = GlobalDispatch.getInstance();
//		GlobalDispatch.getInstance().addObserver(this);
		log.info("成功加入规则主题");
	}

	/**
	 * 连接关闭调用的方法
	 */
	@OnClose
	public void onClose()
	{
		webSocketSet.remove(this); // 从set中删除
		subOnlineCount(); // 在线数减1
		log.debug("有一连接关闭！当前在线人数为" + getOnlineCount());

		if (ob != null)
		{
			ob.deleteObserver(this);
		}
	}

	/**
	 * 收到客户端消息后调用的方法
	 *
	 * @param message
	 *            客户端发送过来的消息
	 */
	@OnMessage
	public void onMessage(String message, Session session)
	{
		log.info("来自客户端的消息:" + message);
	}

	@OnError
	public void onError(Session session, Throwable error)
	{
		log.error("发生错误", error);
	}

	public void sendMessage(String message) throws IOException
	{
		this.session.getBasicRemote().sendText(message);
		// this.session.getAsyncRemote().sendText(message);
	}

	/**
	 * 群发自定义消息
	 */
	public static void sendInfo(String message) throws IOException
	{
		log.debug("——----RuleWebSocket开始群发消息------");
		log.debug("消息内容为：" + message);
		for (RuleWebSocket item : webSocketSet)
		{
			try
			{
				item.sendMessage(message);
			}
			catch (IOException e)
			{
				log.error(item.session.getId() + "消息发送失败", e);
				continue;
			}
		}
		log.debug("——----RuleWebSocket结束群发消息------");
	}

	public static synchronized int getOnlineCount()
	{
		return onlineCount;
	}

	public static synchronized void addOnlineCount()
	{
		RuleWebSocket.onlineCount++;
	}

	public static synchronized void subOnlineCount()
	{
		RuleWebSocket.onlineCount--;
	}

	@Override
	public void update(Observable o, Object arg)
	{
		try
		{
			if (session.isOpen())
			{
				sendMessage(arg.toString());
				log.debug("session" + name + "消息发送成功");
			}
			else
			{
				o.deleteObserver(this);
				log.debug("session" + name + "消息发送失败：" + "session已经失去连接");
			}
		}
		catch (Exception e)
		{
			log.error("session" + name + "消息发送失败：" + e.getMessage());
		}
	}
}
