package com.yeejoin.amos.boot.module.ugp.api.Enum;

import java.util.HashMap;
import java.util.Map;

public enum ProjectInitiationEnum {
    项目立项("1","项目立项"),
    平台审核("2","平台审核"),
    告知申请("3","告知申请"),
    接受告知("4","接受告知"),
    审查项目("5","审查项目"),
    提交资料("6","提交资料"),
    审批人审批("7","审批人审批"),
    审核人审核("8","审核人审核"),
    监检科室分配("9","监检科室分配"),
    监检员分配("10","监检员分配"),
    监检员审核("11","监检员审核"),
    项目关闭("12","项目关闭"),
    接受审查意见("13","接受审查意见");

    private String status;
    private String name;

    public static Map<String,String> getNameByStatusMap = new HashMap<String,String>();
    public static Map<String,String> getStatusByNameMap = new HashMap<String,String>();
    static {
        for(ProjectInitiationEnum projectInitiationEnum:ProjectInitiationEnum.values()){
            getNameByStatusMap.put(projectInitiationEnum.status,projectInitiationEnum.name);
            getStatusByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.status);
        }
    }




    ProjectInitiationEnum(String status, String name) {
        this.status = status;
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
