package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ugp.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IEquipmentService;
import com.yeejoin.amos.boot.module.ugp.api.dto.EquipmentDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 设备信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class EquipmentServiceImpl extends BaseService<EquipmentDto, Equipment, EquipmentMapper> implements IEquipmentService {
    @Autowired
    EquipmentMapper equipmentMapper;

    /**
     * 分页查询
     */
    public Page<EquipmentDto> queryForEquipmentPage(Page<EquipmentDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<EquipmentDto> queryForEquipmentList() {
        return this.queryForList("", false);
    }

    /**
     * 设备数据名称查询
     *
     * @return
     */
    public List<JSONObject> selectName(String installationUnitId) {
        List<JSONObject> names = new ArrayList<>();
        //添加查询条件
        QueryWrapper<Equipment> wrapper = new QueryWrapper<>();
        wrapper.eq("company_id", installationUnitId);

        List<Equipment> equipment = equipmentMapper.selectList(wrapper);

        for (Equipment i : equipment) {
            JSONObject name = new JSONObject();
            name.put("name", i.getName());
            name.put("code", i.getCode());
            names.add(name);
        }

        return names;
    }
}