package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectResourceEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectResourceService;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectResourceDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectResourceEnum.*;

/**
 * 项目资源表（包括焊工、管材、设备）服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class ProjectResourceServiceImpl extends BaseService<ProjectResourceDto, ProjectResource, ProjectResourceMapper> implements IProjectResourceService {
    @Autowired
    EquipmentMapper equipmentMapper;
    @Autowired
    ProjectResourceMapper projectResourceMapper;


    /**
     * 分页查询
     */
    public Page<ProjectResourceDto> queryForProjectResourcePage(Page<ProjectResourceDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ProjectResourceDto> queryForProjectResourceList() {
        return this.queryForList("", false);
    }

    /**
     * 存储项目设备关系
     */
    public ProjectResource saveIds(JSONObject jsonObject) {
        JSONArray subForm = jsonObject.getJSONArray("subForm");
        ProjectResource projectResource = new ProjectResource();

        for (Object json2 : subForm) {
            String select = JSON.parseObject(JSON.toJSONString(json2)).getString("select");
//            if (!jsonObject.getString("sequenceNbr").isEmpty()){
//                jsonObject.getString("sequenceNbr");
//            }
            String code = jsonObject.getString("code");
            String type = jsonObject.getString("type");
            if (type.equals(设备资源.getStatus())) {
                projectResource.setType(设备资源.getState());
            }
            if (type.equals(焊工资源.getStatus())) {
                projectResource.setType(焊工资源.getState());
            }
            if (type.equals(管材资源.getStatus())) {
                projectResource.setType(管材资源.getState());
            }
            projectResource.setProjectId(Long.valueOf(code));
            projectResource.setResourceId(Long.valueOf(select));
            this.save(projectResource);

        }
        return projectResource;


    }
}