package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class ProjectServiceImpl extends BaseService<ProjectDto, Project, ProjectMapper> implements IProjectService {
    @Autowired
    ProjectMapper projectMapper;

    /**
     * 分页查询
     */
    public Page<ProjectDto> queryForProjectPage(Page<ProjectDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ProjectDto> queryForProjectList() {
        return this.queryForList("", false);
    }

    /**
     * 查询项目名称
     */
    public List<JSONObject> selectName() {
        List<JSONObject> names = new ArrayList<>();
        //查询所有项目
        List<Project> projects = projectMapper.selectList(null);
        for (Project i : projects) {
            JSONObject name = new JSONObject();
            name.put("name", i.getName());
            name.put("sequenceNbr", i.getSequenceNbr());
            names.add(name);
        }

        return names;
    }
}