package com.yeejoin.amos.boot.module.elevator.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;


@Data
@Accessors(chain = true)
@Document(indexName = "cylinder_filling", shards = 6, replicas = 2)
public class ESCylinderFillingRecordDto {

    @Id
    private Long sequenceNbr;

    //充装单位
    @Field(type = FieldType.Text)
    private String fillingUnitName;

    //出厂编号
    @Field(type = FieldType.Text)
    private String factoryNum;

    //气瓶品种code
    @Field(type = FieldType.Integer)
    private Integer cylinderVariety;

    //气瓶品种名称
    @Field(type = FieldType.Text)
    private String cylinderVarietyName;

    //二维码编号
    @Field(type = FieldType.Text)
    private String qrCode;

    //电子标签编号
    @Field(type = FieldType.Text)
    private String electronicLabelCode;

    //气瓶唯一标识
    @Field(type = FieldType.Text)
    private String sequenceCode;

    //单位内部编号
    @Field(type = FieldType.Text)
    private String unitInnerCode;

    //产权单位名称
    @Field(type = FieldType.Text)
    private String unitName;

    //气瓶状态code
    @Field(type = FieldType.Integer)
    private Integer cylinderStatus;

    //气瓶状态名称
    @Field(type = FieldType.Text)
    private String cylinderStatusStr;

    //充装开始时间
    @Field(type = FieldType.Text)
    private String fillingStartTime;

    //充装结束时间
    @Field(type = FieldType.Text)
    private String fillingEndTime;

    //充装人员姓名
    @Field(type = FieldType.Text)
    private String fillingUser;

    //充装量（Kg）
    @Field(type = FieldType.Double)
    private Double fillingQuantity;

    //室温
    @Field(type = FieldType.Double)
    private Double temperature;

    //异常情况
    @Field(type = FieldType.Text)
    private String abnormalStr;


    //充装前检查人员姓名
    @Field(type = FieldType.Text)
    private String inspectorUser;

    //充装前检查时间
    @Field(type = FieldType.Text)
    private String inspectionDate;

    //充装前检查结果
    @Field(type = FieldType.Text)
    private String fillingResult;


    //重装后检查人员姓名
    @Field(type = FieldType.Text)
    private String inspector;

    //重装后检查时间
    @Field(type = FieldType.Text)
    private String inspectionDateAfter;

    //重装后检查结果
    @Field(type = FieldType.Text)
    private String checkResult;

    //appid
    @Field(type = FieldType.Text)
    private String appId;

    //统一社会信用代码
    @Field(type = FieldType.Text)
    private String creditCode;

    //行政区划代码
    @Field(type = FieldType.Text)
    private String regionCode;

}
