package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 安全追溯-电梯
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgTechParamsElevatorDto", description = "安全追溯-电梯")
public class IdxBizJgTechParamsElevatorDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @TableField("RECORD")
    private String record;


    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "额定速度（上行）")
    @TableField("RATED_SPEED_UP")
    private String ratedSpeedUp;

    @ApiModelProperty(value = "额定速度（下行）")
    @TableField("RATED_SPEED_DOWN")
    private String ratedSpeedDown;

    @ApiModelProperty(value = "额定载重量")
    @TableField("RATED_LOAD_CAPACITY")
    private String ratedLoadCapacity;

    @ApiModelProperty(value = "轿厢尺寸")
    @TableField("CAR_SIZE")
    private String carSize;

    @ApiModelProperty(value = "提升高度")
    @TableField("LIFTING_HEIGHT")
    private String liftingHeight;

    @ApiModelProperty(value = "层")
    @TableField("STOREY")
    private Integer storey;

    @ApiModelProperty(value = "站")
    @TableField("STAND")
    private Integer stand;

    @ApiModelProperty(value = "门数")
    @TableField("NUMBER_DOORS")
    private Integer numberDoors;

    @ApiModelProperty(value = "控制方式")
    @TableField("CONTROL_MODE")
    private String controlMode;

    @ApiModelProperty(value = "油缸数量")
    @TableField("NUMBER_CYLINDERS")
    private Integer numberCylinders;

    @ApiModelProperty(value = "顶升型式")
    @TableField("JACKING_TYPE")
    private String jackingType;

    @ApiModelProperty(value = "额定压力")
    @TableField("RATED_PRESSURE")
    private String ratedPressure;

    @ApiModelProperty(value = "防爆型式")
    @TableField("EXPLOSIONPROOF_TYPE")
    private String explosionproofType;

    @ApiModelProperty(value = "防爆等级")
    @TableField("EXPLOSIONPROOF_GRADE")
    private String explosionproofGrade;

    @ApiModelProperty(value = "燃爆物质")
    @TableField("EXPLOSIVE_SUBSTANCE")
    private String explosiveSubstance;

    @ApiModelProperty(value = "整机防爆标志")
    @TableField("EXPLOSIONPROOF_SIGN_COMPLETE")
    private String explosionproofSignComplete;

    @ApiModelProperty(value = "驱动主机额定功率")
    @TableField("QDZJ_RATED_POWER")
    private String qdzjRatedPower;

    @ApiModelProperty(value = "驱动主机额定转速")
    @TableField("QDZJ_RATED_SPEED")
    private String qdzjRatedSpeed;

    @ApiModelProperty(value = "驱动主机减速比")
    @TableField("QDZJ_REDUCTION_RATIO")
    private String qdzjReductionRatio;

    @ApiModelProperty(value = "液压泵站满载工作压力")
    @TableField("YABZ_FULLLOAD_PRESSURE")
    private String yabzFullloadPressure;

    @ApiModelProperty(value = "悬挂系统悬挂介质种类")
    @TableField("XGXL_MEDIA_TYPE")
    private String xgxlMediaType;

    @ApiModelProperty(value = "悬挂系统悬挂介质数量")
    @TableField("XGXL_MEDIA_NUMBER")
    private Integer xgxlMediaNumber;

    @ApiModelProperty(value = "悬挂系统悬挂介质型号")
    @TableField("XGXL_MEDIA_MODEL")
    private String xgxlMediaModel;

    @ApiModelProperty(value = "悬挂系统悬挂介质规格")
    @TableField("XGXL_MEDIA_SPECIFICATION")
    private String xgxlMediaSpecification;

    @ApiModelProperty(value = "驱动主机型号")
    @TableField("QDZJ_MODEL")
    private String qdzjModel;

    @ApiModelProperty(value = "驱动主机产品编号")
    @TableField("QDZJ_PRODUCT_NO")
    private String qdzjProductNo;

    @ApiModelProperty(value = "驱动主机制造单位")
    @TableField("QDZJ_MANUFACTURER")
    private String qdzjManufacturer;

    @ApiModelProperty(value = "控制柜型号")
    @TableField("KZG_MODEL")
    private String kzgModel;

    @ApiModelProperty(value = "控制柜产品编号")
    @TableField("KZG_PRODUCT_NO")
    private String kzgProductNo;

    @ApiModelProperty(value = "控制柜制造单位")
    @TableField("KZG_MANUFACTURER")
    private String kzgManufacturer;

    @ApiModelProperty(value = "限速器型号")
    @TableField("XSQ_MODEL")
    private String xsqModel;

    @ApiModelProperty(value = "限速器产品编号")
    @TableField("XSQ_PRODUCT_NO")
    private String xsqProductNo;

    @ApiModelProperty(value = "限速器制造单位")
    @TableField("XSQ_MANUFACTURER")
    private String xsqManufacturer;

    @ApiModelProperty(value = "安全钳型号")
    @TableField("AQQ_MODEL")
    private String aqqModel;

    @ApiModelProperty(value = "安全钳产品编号")
    @TableField("AQQ_PRODUCT_NO")
    private String aqqProductNo;

    @ApiModelProperty(value = "安全钳制造单位")
    @TableField("AQQ_MANUFACTURER")
    private String aqqManufacturer;

    @ApiModelProperty(value = "轿厢缓冲器型号")
    @TableField("JXHCQ_MODEL")
    private String jxhcqModel;

    @ApiModelProperty(value = "轿厢缓冲器产品编号")
    @TableField("JXHCQ_PRODUCT_NO")
    private String jxhcqProductNo;

    @ApiModelProperty(value = "轿厢缓冲器制造单位")
    @TableField("JXHCQ_MANUFACTURER")
    private String jxhcqManufacturer;

    @ApiModelProperty(value = "对重缓冲器型号")
    @TableField("DCHCQ_MODEL")
    private String dchcqModel;

    @ApiModelProperty(value = "对重缓冲器产品编号")
    @TableField("DCHCQ_PRODUCT_NO")
    private String dchcqProductNo;

    @ApiModelProperty(value = "对重缓冲器制造单位")
    @TableField("DCHCQ_MANUFACTURER")
    private String dchcqManufacturer;

    @ApiModelProperty(value = "层门门锁装置型号")
    @TableField("CMMSZZ_MODEL")
    private String cmmszzModel;

    @ApiModelProperty(value = "层门门锁装置产品编号")
    @TableField("CMMSZZ_PRODUCT_NO")
    private String cmmszzProductNo;

    @ApiModelProperty(value = "层门门锁装置制造单位")
    @TableField("CMMSZZ_MANUFACTURER")
    private String cmmszzManufacturer;

    @ApiModelProperty(value = "轿门门锁装置型号")
    @TableField("JMMSZZ_MODEL")
    private String jmmszzModel;

    @ApiModelProperty(value = "轿门门锁装置产品编号")
    @TableField("JMMSZZ_PRODUCT_NO")
    private String jmmszzProductNo;

    @ApiModelProperty(value = "轿门门锁装置制造单位")
    @TableField("JMMSZZ_MANUFACTURER")
    private String jmmszzManufacturer;

    @ApiModelProperty(value = "上行超速保护装置型号")
    @TableField("SXCSBHZZ_MODEL")
    private String sxcsbhzzModel;

    @ApiModelProperty(value = "上行超速保护装置产品编号")
    @TableField("SXCSBHZZ_PRODUCT_NO")
    private String sxcsbhzzProductNo;

    @ApiModelProperty(value = "上行超速保护装置制造单位")
    @TableField("SXCSBHZZ_MANUFACTURER")
    private String sxcsbhzzManufacturer;

    @ApiModelProperty(value = "轿厢意外移动保护装置型号")
    @TableField("JXYWYDBHZZ_MODEL")
    private String jxywydbhzzModel;

    @ApiModelProperty(value = "轿厢意外移动保护装置")
    @TableField("JXYWYDBHZZ_PRODUCT_NO")
    private String jxywydbhzzProductNo;

    @ApiModelProperty(value = "轿厢意外移动保护装置制造单位")
    @TableField("JXYWYDBHZZ_MANUFACTURER")
    private String jxywydbhzzManufacturer;

    @ApiModelProperty(value = "液压泵站型号")
    @TableField("YYBZ_MODEL")
    private String yybzModel;

    @ApiModelProperty(value = "液压泵站产品编号")
    @TableField("YYBZ_PRODUCT_NO")
    private String yybzProductNo;

    @ApiModelProperty(value = "液压泵站制造单位")
    @TableField("YYBZ_MANUFACTURER")
    private String yybzManufacturer;

    @ApiModelProperty(value = "限速切断阀型号")
    @TableField("XSQDF_MODEL")
    private String xsqdfModel;

    @ApiModelProperty(value = "限速切断阀产品编号")
    @TableField("XSQDF_PRODUCT_NO")
    private String xsqdfProductNo;

    @ApiModelProperty(value = "限速切断阀制造单位")
    @TableField("XSQDF_MANUFACTURER")
    private String xsqdfManufacturer;

    @ApiModelProperty(value = "名义速度")
    @TableField("NOMINAL_SPEED")
    private String nominalSpeed;

    @ApiModelProperty(value = "倾斜角")
    @TableField("ANGLE_ROLL")
    private String angleRoll;

    @ApiModelProperty(value = "名义宽度")
    @TableField("NOMINAL_WIDTH")
    private String nominalWidth;

    @ApiModelProperty(value = "使用区段长度")
    @TableField("USE_SECTION_LENGTH")
    private String useSectionLength;

    @ApiModelProperty(value = "输送能力")
    @TableField("CONVEYING_CAPACITY")
    private String conveyingCapacity;

    @ApiModelProperty(value = "工作类型")
    @TableField("WORK_TYPE")
    private String workType;

    @ApiModelProperty(value = "工作环境")
    @TableField("WORK_ENVIRONMENT")
    private String workEnvironment;

    @ApiModelProperty(value = "控制柜节能运行方式")
    @TableField("KZG_OPERATION_MODE")
    private String kzgOperationMode;

    /**
     * 参数是否完整齐全：1-齐全；2-不齐全 【历史无证设备需要】
     */
    private String techParamIsComplete;
}
