package com.yeejoin.amos.boot.module.ys.biz.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.yeejoin.amos.boot.biz.config.MetaHandler;
import com.yeejoin.amos.boot.biz.config.MybatisSqlInjector;
import com.zaxxer.hikari.HikariDataSource;
import io.seata.rm.datasource.DataSourceProxy;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import javax.sql.DataSource;

/**
 * 数据源代理
 *
 * @author LiuLin
 */
@Configuration
public class DataSourceConfiguration {


    @Bean("dataSource")
    public DataSourceProxy dataSourceProxy(HikariDataSourceProperties hikariDataSourceProperties, DataSourceProperties dataSourceProperties) {
        HikariDataSource dataSource = dataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        dataSource.setMaximumPoolSize(hikariDataSourceProperties.getMaximumPoolSize());
        dataSource.setMinimumIdle(hikariDataSourceProperties.getMinimumIdle());
        dataSource.setMaxLifetime(hikariDataSourceProperties.getMaxLifetime());
        dataSource.setPoolName(hikariDataSourceProperties.getPoolName());
        dataSource.setConnectionTestQuery(hikariDataSourceProperties.getConnectionTestQuery());
        dataSource.setIdleTimeout(hikariDataSourceProperties.getIdleTimeout());
        dataSource.setConnectionTimeout(hikariDataSourceProperties.getConnectionTimeout());
        dataSource.setIdleTimeout(hikariDataSourceProperties.getIdleTimeout());
        dataSource.setConnectionInitSql(hikariDataSourceProperties.getConnectionInitSql());
        return new DataSourceProxy(dataSource);
    }

    @Bean(name = "sqlSessionFactory")
    public SqlSessionFactory sqlSessionFactoryBean(DataSource dataSourceProxy, PaginationInterceptor paginationInterceptor, MybatisPlusProperties mybatisPlusProperties,GlobalConfig globalConfig) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSourceProxy);
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        bean.setMapperLocations(resolver.getResources("classpath*:mapper/*.xml"));
        bean.setConfigurationProperties(mybatisPlusProperties.getConfigurationProperties());
        bean.setGlobalConfig(globalConfig);
        Interceptor[] plugins = {paginationInterceptor};
        bean.setPlugins(plugins);
        return bean.getObject();
    }
}
