package com.yeejoin.amos.boot.module.ccs.api.mapper;

import com.yeejoin.amos.boot.module.ccs.api.dto.FireStationInfoDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireStationInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ccs.api.vo.AlarmCountVO;
import com.yeejoin.amos.boot.module.ccs.api.vo.DateAlarmCountVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 站端信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface FireStationInfoMapper extends BaseMapper<FireStationInfo> {

    /**
     * 换流站列表
     * @return List<FireStationInfoDto>
     * @param orderBy
     */
    List<FireStationInfoDto> queryStationListWithStatistics(String orderBy);

    /**
     * 换流站装备信息
     * @param stationCode
     * @param stationName
     * @return
     */
    List<Map<String, Object>> queryStationEquipInfo(@Param("stationCode") String stationCode, @Param("stationName") String stationName);

    List<Map<String, Object>> lastYearAlarmCount();

    /**
     * 换流站告警信息
     *
     * @param stationCode
     * @return List<FireStationInfoDto>
     */
    List<FireStationInfoDto> queryStationAlarmListByCode(@Param("stationCode") String stationCode);

    /**
     * 查询各个环流站的警情数量
     *
     * @return
     */
    List<AlarmCountVO> queryAlarmCountByCode();

    /**
     * 查询各个环流站的警情数量（包含历史和即时警情）
     *
     * @return
     */
    List<AlarmCountVO> queryAllAlarmCountByCode(@Param("beginDateTime") String beginDateTime, @Param("endDateTime") String endDateTime);

    /**
     * 根据code和时间查警情数量
     *
     * @return
     */
    Integer queryAlarmCountByDateAndCode(@Param("stationCode") String stationCode, @Param("date") String date);

    /**
     * 查询指定时间段的告警趋势
     *
     * @param stationCode
     * @param beginDate
     * @param endDate
     * @return
     */
    List<DateAlarmCountVO> getAlarmTrendByDatePeriod(@Param("stationCode") String stationCode, @Param("beginDate") String beginDate, @Param("endDate") String endDate);

    /**
     * 查询指定时间段的告警趋势
     *
     * @param stationCode
     * @param beginDateTime
     * @param endDateTime
     * @return
     */
    List<DateAlarmCountVO> getAlarmNumByDateTimePeriodByStationCode(@Param("stationCode") String stationCode, @Param("beginDateTime") String beginDateTime, @Param("endDateTime") String endDateTime);

}
