package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author tb
 * @date 2021-01-28
 */
@Data
public class TaskRiskControlTechDto extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "风险作业计划名称")
    private String name;

    @ApiModelProperty(value = "安全负责人员")
    private Long personId;

    /**
     * 安全人员名称
     */
    private String techPersonName;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "计划开始时间")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "计划结束时间")
    private Date endTime;

    /**
     * 风险计划任务状态
     */
    private String statusCode;

    /**
     * 阶段列表
     */
    private List<String> stageList;

    /**
     * 组织机构代码
     */
    private String orgCode;
    
    @ApiModelProperty(value = "待开始")
    private Boolean toStart;
	@ApiModelProperty(value = "任务状态")
	private List<Long> status;
	@ApiModelProperty(value = "超时状态")
	private Long currentStatus;
	@ApiModelProperty(value = "阶段")
	private Integer stage;
	@ApiModelProperty(value = "等级")
	private Integer level;
	
	private Integer type;
	
	private String projectName;
	
	private String search;
	
	private long isJxdj;
	
	private Long companyId;
}
