package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 作业活动
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task")
@ApiModel(value = "Task对象", description = "作业活动")
public class Task extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "作业类型 0 技术交底 1三交三查 2违规任务")
    private Long type;
    @ApiModelProperty(value = "方案名称")
    private String name;
    @ApiModelProperty(value = "代号")
    private String code;
    @ApiModelProperty(value = "编号")
    private String number;
    @ApiModelProperty(value = "天气")
    private String weather;
    @ApiModelProperty(value = "发起人id")
    private Long createPersonId;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "任务状态 0进行中、1已完成、2待审核、3驳回")
    private Long status;
    @ApiModelProperty(value = "任务单号")
    private String taskNo;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "未完成任务的当前状态")
    private Long currentStatus;
    @ApiModelProperty(value = "风险作业确认状态")
    private Long riskStatus;
    @ApiModelProperty(value = "检查项确认状态")
    private Long builderStatus;
    @ApiModelProperty(value = "机构ID")
    private String orgCode;

}
