package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IESeqService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author ZeHua Li
 * @date 2020/10/29 14:26
 * @since v2.0
 */
@RestController
@Api(tags = "设备报警日志信息")
@RequestMapping(value = "/equipSpecificAlarmLog")
public class EquipmentSpecificAlarmLogController extends AbstractBaseController {

    @Autowired
    IEquipmentSpecificAlarmLogService equipmentSpecificAlarmLogService;
    @Autowired
    IESeqService eSeqService;
    /**
     * 获取告警设备日月环比信息
     *
     * @param date
     * @return
     */
    @RequestMapping(value = "/equipAlarmLink", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取告警设备日月环比信息", notes = "获取告警设备日月环比信息")
    public ResponseModel equipAlarmLink(@RequestParam(required = false) String date) {
        return CommonResponseUtil.success(equipmentSpecificAlarmLogService.equipAlarmLink(date));
    }
    /**
     * 获取设备物联日志
     *
     * @param
     * id：系统id
     * startTime：开始时间
     * endTime：结束时间
     * @return
     */
    @RequestMapping(value = "/getEquipAlarmLog", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "获取设备物联日志", notes = "获取设备物联日志")
    public ResponseModel getEquipAlarmLog(@RequestParam(required = false) String code,
                                          @RequestParam(required = false) String startTime,
                                          @RequestParam(required = false) String endTime,
                                          @RequestParam(required = false) int pageSize,
                                          @RequestParam(required = false) int current ) {
        return CommonResponseUtil.success(equipmentSpecificAlarmLogService.getEquipAlarmLog(code,startTime,endTime, pageSize,current));
    }

    @RequestMapping(value = "/getEquipAlarmLogtest", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取设备物联日志", notes = "获取设备物联日志")
    public ResponseModel getEquipAlarmLog( ) {

        eSeqService.deleteESEquiplistSpecificBySystemES();

        return CommonResponseUtil.success();
    }


    @RequestMapping(value = "/updateStatusByAlarm", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "批量消除log表所有设备告警及归位", notes = "批量消除log表所有设备告警及归位")
    public ResponseModel updateStatusByAlarm() {
        equipmentSpecificAlarmLogService.updateStatusByAlarm();
        return CommonResponseUtil.success();
    }




}






