package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: AlarmStatisticController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/7/31 19:33
 */
@RestController
@Api(tags = "关键数据相关API")
@RequestMapping(value = "/keyWordsInfo", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class KeyWordsInfoController extends AbstractBaseController {

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/CAFS/cannon", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取消防炮统计信息", notes = "获取消防炮统计信息")
    public ResponseModel getFireCannonInfo(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> list = iFireFightingSystemService.getFireCannonInfo(bizOrgCode);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "查询已绑定排油阀的换流变信息", notes = "查询已绑定排油阀的换流变信息")
    @RequestMapping(value = "/getFEquipInfoList", method = RequestMethod.GET)
    public ResponseModel getFEquipInfoList(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> resultList = iFireFightingSystemService.getFEquipInfoList(bizOrgCode);
        return CommonResponseUtil.success(resultList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "查询已绑定排油阀的换流变信息 - 根据分类分组", notes = "查询已绑定排油阀的换流变信息 - 根据分类分组")
    @RequestMapping(value = "/getFEquipInfoListCategory", method = RequestMethod.GET)
    public ResponseModel getFEquipInfoListCategory(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> resultList = iFireFightingSystemService.getFEquipInfoListCategory(bizOrgCode);
        return CommonResponseUtil.success(resultList);
    }

}
