package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipment;
import com.yeejoin.equipmanage.common.datasync.vo.FireEquipmentVO;
import com.yeejoin.equipmanage.common.dto.EquipmentSpecificDto;
import com.yeejoin.equipmanage.common.dto.FireFightingSystemDto;
import com.yeejoin.equipmanage.common.dto.UserDto;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentSpecificDTO;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.*;

/**
 * 消防资源配置 Mapper 接口
 *
 * @date 2020-07-07
 */
@Mapper
public interface EquipmentSpecificMapper extends BaseMapper<EquipmentSpecific> {
    List<EquipmentSpecificVo> getEquipmentSpe(Map<String, Object> map);

    int getEquipmentSpeCount(Map<String, Object> map);

    List<Map<String, Object>> getEquipmentCount(@Param("bizOrgCode") String bizOrgCode);
    List<Map<String, Long>> getEquipmentCountBySystemId(@Param("bizOrgCode") String bizOrgCode, @Param("systemIds") List<Long> systemIds);

    IPage<ComplementCodeVO> selectEquipmentSpecific(Page page, EquipmentSpecificDTO equipmentSpecificDTO);

    /**
     * 获取iot_code
     *
     * @return
     */
    List<EquipmentSpecificVo> getEquipmentSpecificIotCode();

    /**
     * 获取稳压泵  iot_code
     *
     * @return
     */
    List<EquipmentSpecificVo> getEquipmentSpecificIotCodeWYB();

    /**
     * @Return: List<String>
     * @Throws
     * @Date 2020/11/13 9:19
     */
    List<EquipmentSpecificVo> getEquipIotCodeLists();

    List<PointTreeVo> getPointData();


    List<PointTreeVo> getSystemEquList(@Param("orgCode") String orgCode, @Param("id") Long id);

    List<EquipmentSpecificVo> getEquipOrCarByIotCode(@Param("iotCode") String iotCode);

    String getFirstCanvas(@Param("orgCode") String orgCode);

    String getSceneName(String id);

    List<PointTreeVo> getSystemmeanLsit();

    List<PointTreeVo> getSceList(@Param("orgCode") String orgCode);

    List<EquipmentSpecificIndex> getEquipMentStatus(@Param("id") String id);

    List<EquipmentSpecificIndex> getEquipIndexLatestStatus();

    /**
     * 根据画布id获取画布绑定设备最新指标状态
     *
     * @param sceneId
     * @return
     */
    List<EquipmentSpecificIndex> getEquipLatestStatusBySceneId(String sceneId);

    List<Map<String, Object>> getStatusAll(@Param("sceneId") String sceneId);


    List<String> getEquipmentIotCodeLists();

    List<HashMap<String, Object>> getEquipBySourceId(@Param("sourceIds") List<Long> sourceIds, @Param("categoryId") List<Long> categoryId, @Param("equipCode") String equipCode, @Param("equipName") String equipName, @Param("companyId") String companyId, @Param("current") Long current, @Param("size") Long size);

    int getEquipBySourceIdCount(@Param("sourceIds") List<Long> sourceIds, @Param("categoryId") List<Long> categoryId, @Param("equipCode") String equipCode, @Param("equipName") String equipName, @Param("companyId") String companyId);

    List getMenuChildren(@Param("id") Long id);

    List findAllParents();

    List<ImportantEquipmentVO> getEquipment();

    List findAllMenuChildren();

    Long getEquipBySourceIdBycount(@Param("sourceId") String sourceId, @Param("categoryId") String categoryId, @Param("equipCode") String equipCode, @Param("equipName") String equipName);

    EquipmentSpecificVo getEquipmentNameByIotCode(@Param("iotCode") String iotCode);

    /**
     * 拼接组态使用消防装备卡品
     */
    List<Map<String, String>> getOneCard(Long id);

    Map<String, String> getQrCodeAndPic(Long id);

    List<String> getIotCodeList(@Param("id") String id);

    List<Map<String, Object>> getEquipmentList(String alarmSystemCode);

    List<Map<String, Object>> getAlarmEquipmentById(Long id, String alarmSystemCode);

    List<String> selectSystemList(Long id);

    List<String> selectBuildList(Long id);

    SourceNameByEquipSpeIdVO getSourceNameByEquipSpeId(Long id);

    IPage<SourceNameByEquipSpeIdVO> getSourceNameList(IPage page, Long warehouseStructureId, Long sourceId, String equipmentName, String equipmentCode);

    FireEquipment getEquipSpecificDetail(Long id);

    FireEquipmentVO getEquipSpecificDetail2(Long id);

    List<EquipmentCategory> getEquipSpeTypeByQrcode(@Param("qrCode") String qrCode);

    List<FireEquipment> getEquipSpecificDetailsByEquipmentId(Long equipmentId);

    /**
     * 获取设备台账统计信息
     *
     * @param systemId 系统id
     * @return List<EquipCategoryVo>
     */
    List<EquipCategoryVo> selectEquipCategoryNumber(Long systemId);

    List<EquipmentSpecific3dVo> get3dFightingSysEquipList(Long id, String name);

    List<EquipmentSpecific3dVo> listPage(@Param("equipment") EquipFor3DVO equipment, @Param("start") long start, @Param("size") long size);

    int listCount(@Param("equipment") EquipFor3DVO equipment);

    List<LinkedHashMap> get3dFightingSysEquipCount(Long id, Integer status, String name);

    /**
     * @param like   设备名称或编码code
     * @param split  wl_equipment_category，code不包含（右%），多个用英文逗号隔开
     * @param status wl_stock_detail.status
     * @return
     */
    List<EquipmentOnCarVo> getAirEquipSpecificList(@Param("like") String like, @Param("arr") String[] split, @Param("status") Integer status);

    IPage<EquipmentOnCarVo> onCarVoIPage(Page<EquipmentSpecificDto> page, @Param("vo") EquipmentSpecificDto equipmentSpecificDto);

    EquipmentDetailVo getAirEquipSpecificDetail(Long stockDetailId);

    /**
     * 根据已有设备获取系统设备分类集合，未关联设备归为其他
     * wl_equipment_detail.id，f_fire_fighting_system.id分组
     *
     * @return
     */
    List<MaintenanceResourceDataVo> getSysEquipClassifyList();

    List<MaintenanceResourceData> getSysEquipClassifyDataList();

    IPage<MaintenanceResourceDataVo> getSysEquipClassifyDataPage(Page page, Long fireFightSysId, String fireFacilityName, String classifyId, Long fireFacilityId, List<Long> buildingId, List<String> bandWbCompany);

    IPage<MaintenanceResourceDataVo> getEquipClassifyDataPage(Page page, Long fireFightSysId, String fireFacilityName, String classifyId, Long fireFacilityId, List<Long> buildingId, List<String> bandWbCompany);

    List<UserDto> getEquipSpecificLocationInfo(Long equipmentSpecificId, String[] fieldName);

    Map<String, Double> getEquipLocationInfo(Long equipmentSpecificId);

    Map<String, Object> getEquipSpeInfo(@Param("equipmentSpecificId") Long equipmentSpecificId);

    /**
     * 根据specificId删除装备相关数据
     *
     * @param specificId specificId
     */
//    void deleteEquipDataBySpecificId(@Param("specificId") Long specificId, @Param("equipDetailId") Long equipDetailId);


    void deleteEquipDetail(@Param("equipDetailId") Long equipDetailId);

    void deleteEquipAlarmLog(@Param("speId") Long speId);

    void deleteEquipAlarm(@Param("speId") Long speId);

    void deleteEquipReportDay(@Param("speId") Long speId);

    void deleteEquipSpecIndex(@Param("speId") Long speId);

    void deleteEquipSpecVideo(@Param("speId") Long speId);

    void deleteEquipSpecRelation(@Param("speId") Long speId);

    void deleteEquipSpec(@Param("speId") Long speId);

    /**
     * 根据库存id删除装备相关库存数据
     *
     * @param stockDetailId 库存明细id
     * @param specificId    specificId
     */
    void deleteEquipDataByStockDetailId(@Param("stockDetailId") Long stockDetailId, @Param("specificId") Long specificId);

    /**
     * 获取雨淋阀室指标详情
     *
     * @return 指标详情
     */
    List<Map<String, String>> getRainRoomIndexDetails();

    /**
     * 消防管网指标详情
     *
     * @return 指标详情
     */
    List<Map<String, String>> getTropicsIndexDetails();

    /**
     * 选择阀室指标详情
     *
     * @return 指标详情
     */
    List<Map<String, String>> getChoiceRoomIndexDetails();

    /**
     * 消防炮伴热带指标详情
     *
     * @return 指标详情
     */
    List<Map<String, String>> getBoxTropicsIndexDetails();


    /**
     * 统计数据
     *
     * @return
     */
    List<Map<String, Object>> queryCompanyStaData();

    Equipment getEquipmentBySpecificId(@Param("specificId") Long specificId);

    /**
     * @param floorId 建筑id
     * @param isIot   是否物联设备
     * @return
     */
    List<EquiplistSpecificBySystemVO> getListByWarehouseStructureId(Long floorId, Integer isIot);


    List<Map<String, String>> getStationInfo();


    List<Map<String, Object>> getFireMonitorInfo(@Param("equipmentId") Long fireEquipmentId, @Param("list") String[] strings);

    List<Map<String, Object>> getFirePumpInfoCSZZ(@Param("list") String[] strings,@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getFirePumpInfo(@Param("list") String[] strings, @Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getFirePumpInfoEQ(@Param("list") String[] strings, @Param("bizOrgCode") String bizOrgCode);


    List<Map<String, Object>> getListByEquipmentCode(@Param("list") String[] strings, @Param("bizOrgCode") String bizOrgCode);

    Integer getAllEquipNum(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> normalIndexInfoList(@Param("startDate") String startDate, @Param("endDate") String endDate);

    Page<Map<String, Object>> normalIndexInfoListByPage(@Param("Page") Page<Map<String, Object>> page, @Param("startDate") String startDate, @Param("endDate") String endDate, @Param("systemCode") String systemCode, @Param("name") String name);

    Map<String, Object> getFireAutoSysInfo();

    Map<String, Object> getPaomoSysInfo();

    Map<String, Object> getWaterSysInfo();

    Map<String, Object> getEquipmentStatisticsInfo(@Param("map") Map<String, Object> map);

    Page<FireFightingSystemDto> fireSysIotEquipCount(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    List<FireFightingSystemDto> fireSysIotEquipAlarmCount(Date date, String bizOrgCode);

    List<Map> getWater(@Param("id") Long id);

    Map<String, Object> getStationCode(@Param("id") Long id);

    EquipmentSpecific getEquipSpecificEntityByCode(@Param("code") String code);

    Integer updateEquipSpecificStatus(String status, String id);

    String getEquipStatusList(@Param("id") String id);

    List<Long> countEquipStatusListByEquipId(@Param("id") Long id);

    String getSpecificStatusByEquipmentCode(@Param("equipCode") String equipCode);

    void updateWaterResourceStatus(@Param("id") Long id, @Param("status") String status);

    Integer updateCarStatus(@Param("id") String id, @Param("status") String status);

    String updateEquipSpecificStatusByCheckInput(String id);

    Page<Map<String, Object>> selectListByPatrolCheck(Page<Map<String, Object>> page, String id);

    List<String> selectIdsByPatrolCheck(String id);

    List<Map<String, Object>> queryCheckInputItemsByCheckId(@Param(value = "checkId") String checkId);

    Map<String, Object> getPointById(@Param(value = "pointId") Long id);

    Map<String, Object> getPatrolData(@Param(value = "checkId") Long checkId);

    List<Map<String, Object>> getListByIds(@Param("list") String[] list, @Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getListByCode(@Param("code") String code, @Param("bizOrgCode") String bizOrgCode);

    IPage<EquipTypeImgAmountVO> getMonitoringUnitList(
            @Param("page") IPage page,
            @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage,
            @Param("useSource") String useSource
    );

    List<Map<String, Object>> getMonitoringCount(String bizOrgCode);

    String getEquipIdByCheckInputId(@Param(value = "id") String id);

    Map<String, Object> getMonitoringEquip(String id);

    Map<String, Object> getMonitoringOther(String id);

    void updateEquipQrCode(List<String> ids, String status);

    String selectEquipRealtimeSignal(@Param(value = "id") long id);

    List<Map<String, Object>> getPatrolInfo(String bizOrgCode);

    List<Map<String, Object>> getZJScrapStatics(String bizOrgCode);

    IPage<Map<String, Object>> selectZJEquipmentSpecificWWX(Page page, EquipmentSpecificDTO equipmentSpecific);

    List<Map<String, Object>> selectZJEquipmentSpecificWWXByIds(String bussIds);

    List<Map<String, Object>> getFireEquipStatistic(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getFireEquipListByDefineCode(@Param("offset") long offset, @Param("size") long size, @Param("bizOrgCode") String bizOrgCode, @Param("code") String code, @Param("equipStatus") String equipStatus);

    int count(@Param("bizOrgCode") String bizOrgCode, @Param("code") String code, @Param("equipStatus") String equipStatus);

    Integer selectEquipmentCountBySystemId(@Param("systemId") Long systemId);

    List<EquipTrendInfoVo> getEquipListByCode(@Param("code") String code, @Param("indexKey") String indexKey, @Param("bizOrgCode") String bizOrgCode);

    List<EquipTrendInfoVo> getWaterList(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, String>> getIndexKeyByIotCode(@Param("list") Set<String> list);

    List<Map<String, String>> getIndexKeyByIotCodeWaterTank(@Param("list") Set<String> list);
}
