package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IAlarmService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/api/alarm")
@Api("报警信息api")
public class AlarmController extends AbstractBaseController {
	
	@Autowired 
	IAlarmService iAlarmService;
	
	/**
	 * 风险等级分页查询
	 * 
	 * @param queryRequests
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "报警信息查分页询", notes = "报警信息查询")
	@RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse queryAlarmPage(
			@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
		CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
		Page<HashMap<String, Object>> list = iAlarmService.queryAlarmPage(param);
		return CommonResponseUtil.success(list);
	}
	
}
