package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.tdc.api.entity.SubmitRecord;
import com.yeejoin.amos.boot.module.tdc.api.service.SubmitRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 校验记录
 * @author xxz
 */
@RestController
@Api(tags = "校验项提交")
@RequestMapping(value = "/check-record")
public class SubmitRecordController {
    @Autowired
    SubmitRecordService submitRecordService;

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectOrgCode")
    @ApiOperation(httpMethod = "GET",value = "直接查询列表",  notes = "直接查询列表")
    public ResponseModel<IPage<SubmitRecord>> selectByOrgCode(int current,int size){
        return  ResponseHelper.buildResponse(submitRecordService.selectByOrgCode(current, size));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectRecord")
    @ApiOperation(httpMethod = "GET",value = "查询记录top20",  notes = "查询记录top20")
    public ResponseModel<List<SubmitRecord>> selectRecord(){
        return  ResponseHelper.buildResponse(submitRecordService.selectRecord());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "saveFileId")
    @ApiOperation(httpMethod = "GET",value = "保存文件id",  notes = "保存文件id")
    public ResponseModel saveFileId(@RequestParam(value = "id") Long id, @RequestParam(value = "fileId") Long fileId){
        submitRecordService.saveFileId(id, fileId);
        return  ResponseHelper.buildResponse(true);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "getFileId")
    @ApiOperation(httpMethod = "GET",value = "根据主键id获取文件id",  notes = "根据主键id获取文件id")
    public ResponseModel<SubmitRecord> getFileId(@RequestParam(value = "id") Long id){
        return  ResponseHelper.buildResponse(submitRecordService.getFileId(id));
    }
}