package com.yeejoin.amos.boot.biz.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FieldMapping {
    /**
     * 字段映射配置组
     */
    FieldMap[] value();

    @interface FieldMap {
        // 参数索引位置（默认第0个参数）
        int paramIndex() default 0;

        // 源字段路径（支持嵌套）
        String sourceField();

        // 目标字段路径（支持嵌套）
        String targetField();

        // 查询服务类
        Class<?> serviceClass();

        // 查询方法名
        String queryMethod();

        // 查询参数类型（默认String）
        Class<?> queryParamType() default String.class;

        // 是否覆盖源字段
        boolean overrideSource() default false;

        // 是否直接使用整个参数作为源值
        boolean useEntireParam() default false;

        // 是否替换整个参数
        boolean replaceParam() default false;
    }
}
