package com.yeejoin.amos.boot.biz.common.service;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;

public interface IWorkflowExcuteService{

	/**
	 * 启动流程，并执行完成任务
	 * @param key 流程定义的key
	 * @param condition 执行控制条件
	 */
	String startAndComplete(String key,String condition)throws Exception;	
	
	/**
	 * 检查当前登录人有没有流程操作权限
	 * @param processInstanceId 流程定义的ID
	 * @return true 可以执行，false 无执行权限
	 */
	boolean checkTaskAuth(String processInstanceId, ReginParams userInfo);
	
	/**
	 * 检查当前登录人有没有流程操作权限
	 * @param processInstanceId 流程定义的ID
	 * @return 包含是否执行的角色权限flag，以及当前任务的id
	 */
	Map<String, Object> checkTaskAuthMap(String processInstanceId, ReginParams userInfo);
	/**
	 * 设置当前任务的执行人，只支持当前节点流程拥有单个可执行任务的情况，不支持并行网关产生的多条任务设置人的任务情况
	 * @param processInstanceId
	 * @return
	 */
	Object setTaskAssign(String processInstanceId,String userId);
	/**
	 * 完成task节点任务
	 * @param processInstanceId
	 * @param condition
	 * @param userInfo
	 * @return
	 */
	boolean CompleteTask(String processInstanceId,String condition, ReginParams userInfo);


	/**
	 * 查询并执行一步工作流-无权限
	 * @param procressId 流程id
	 * @param condition 条件
	 * @return boolean
	 * @throws Exception
	 */
	boolean excuteTask(String procressId, String condition) throws Exception;
	
	/**
	 * 获取当前登录用户所能执行的任务信息列表
	 * @param key 流程定义的key ，例如 ：fire_supervision 防火监督
	 * @param userInfo
	 * @return List<map<String,String>> eg: [{ "processInstanceId": "110d3af9-1f5a-11ec-a26e-b07b25133c48"}]
	 * @throws Exception
	 */
	public Object getCurrentUserAllTaskList(String key, ReginParams userInfo) throws Exception;

	/**
	 * 根据流程id获取下一节点操作人员userId集合
	 * @param procressId
	 * @return
	 * @throws Exception
	 */
	public List<String> getUserIdsByWorkflow(String procressId, String checkLeaderId) throws Exception;
}
