package com.yeejoin.amos.api.openapi.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.yeejoin.amos.api.openapi.converter.*;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.converter.CommonCustomConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "西安电梯数据对接", description = "西安电梯数据对接")
public class XiAnElevatorExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    //----------------------------------------------------------------------基本信息
    @ApiModelProperty(value = "设备种类")
    @ExcelProperty(value = "设备种类", converter = EquListConverter.class)
    private String equList;

    @ApiModelProperty(value = "设备类别")
    @ExcelProperty(value = "设备类别", converter = EquCategoryConverter.class)
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    @ExcelProperty(value = "设备品种", converter = EquDefineConverter.class)
    private String equDefine;

    @ApiModelProperty(value = "单位内编号")
    @ExcelProperty(value = "单位内编号")
    private String useInnerCode;

    @ApiModelProperty(value = "产品名称")
    @ExcelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "设备型号")
    @ExcelProperty(value = "设备型号")
    private String equType;

    @ApiModelProperty(value = "设备总价值（万元）")
    @ExcelProperty(value = "设备总价值（万元）")
    private String equPrice;

    @ApiModelProperty(value = "有无设备代码")
    @ExcelProperty(value = "有无设备代码", converter = EquCodeTypeConverter.class)
    private String equCodeType;

    @ApiModelProperty(value = "设备代码")
    @ExcelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "96333码")
    @ExcelProperty(value = "96333码")
    private String code96333;

    @ApiModelProperty(value = "使用登记证编号")
    @ExcelProperty(value = "使用登记证编号")
    private String useOrgCode;

    @ApiModelProperty(value = "登记机关")
    @ExcelProperty(value = "登记机关", converter = CommonCustomConverter.CompanyCodeConverter.class)
    private String oRegUnit;

    @ApiModelProperty(value = "登记日期")
    @ExcelProperty(value = "登记日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String oRegDate;

    @ApiModelProperty(value = "注册代码")
    @ExcelProperty(value = "注册代码")
    private String record;

    @ApiModelProperty(value = "属地监管部门")
    @ExcelProperty(value = "属地监管部门")
    private String orgBranchName;

    @ApiModelProperty(value = "属地监管部门code")
    @ExcelIgnore
    private String orgBranchCode;

    //-----------------------------------------------------------------------使用信息
    @ApiModelProperty(value = "使用单位统一社会信用代码")
    @ExcelProperty(value = "使用单位统一社会信用代码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    @ExcelProperty(value = "使用单位名称")
    private String useUnit;

    @ApiModelProperty(value = "产权单位社会信用代码")
    @ExcelProperty(value = "产权单位社会信用代码")
    private String estateUnitCreditCode;

    @ApiModelProperty(value = "产权单位名称")
    @ExcelProperty(value = "产权单位名称")
    private String estateUnitName;

    @ApiModelProperty(value = "使用地点-省")
    @ExcelProperty(value = "使用地点-省")
    private String provinceName;

    @ApiModelProperty(value = "使用地点-市")
    @ExcelProperty(value = "使用地点-市")
    private String cityName;

    @ApiModelProperty(value = "使用地点-区/县")
    @ExcelProperty(value = "使用地点-区/县")
    private String countyName;

    @ApiModelProperty(value = "使用地点-街道")
    @ExcelProperty(value = "使用地点-街道")
    private String factoryUseSiteStreet;

    @ApiModelProperty(value = "详细地址")
    @ExcelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "使用地点经纬度")
    @ExcelProperty(value = "使用地点经纬度")
    private String longitudeLatitude;

    @ApiModelProperty(value = "使用场所")
    @ExcelProperty(value = "使用场所", converter = UsePlaceConverter.class)
    private String usePlace;

    @ApiModelProperty(value = "安全管理员")
    @ExcelProperty(value = "安全管理员")
    private String safetyManager;

    @ApiModelProperty(value = "安全管理员联系电话")
    @ExcelProperty(value = "安全管理员联系电话")
    private String phone;

    @ApiModelProperty(value = "安全管理员身份证号")
    @ExcelProperty(value = "安全管理员身份证号")
    private String safetyManagerIDNumber;

    @ApiModelProperty(value = "投用日期")
    @ExcelProperty(value = "投用日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String useDate;
    //---------------------------------------------------------------制造信息

    @ApiModelProperty(value = "制造单位统一社会信用代码")
    @ExcelProperty(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    @ExcelProperty(value = "制造单位名称")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    @ExcelProperty(value = "制造许可编号")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号/产品编码")
    @ExcelProperty(value = "出厂编号/产品编码")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    @ExcelProperty(value = "制造日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String produceDate;

    @ApiModelProperty(value = "是否进口")
    @ExcelProperty(value = "是否进口", converter = ImportedConverter.class)
    private String imported;

    @ApiModelProperty(value = "制造国")
    @ExcelProperty(value = "制造国")
    private String produceCountry;

    //---------------------------------------------------------------安装信息

    @ApiModelProperty(value = "安装单位")
    @ExcelProperty(value = "安装单位")
    private String installUnitName;

    @ApiModelProperty(value = "安装单位统一信用代码")
    @ExcelProperty(value = "安装单位统一信用代码")
    private String installUnitCreditCode;

    @ApiModelProperty(value = "安装负责人")
    @ExcelProperty(value = "安装负责人")
    private String installLeaderName;

    @ApiModelProperty(value = "安装负责人联系电话")
    @ExcelProperty(value = "安装负责人联系电话")
    private String installLeaderPhone;

    @ApiModelProperty(value = "安装负责人身份证号")
    @ExcelProperty(value = "安装负责人身份证号")
    private String installLeaderIDNumber;

    @ApiModelProperty(value = "安装日期")
    @ExcelProperty(value = "安装日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String installStartDate;

    //--------------------------------------------------------------------检验信息

    @ApiModelProperty(value = "检验机构名称")
    @ExcelProperty(value = "检验机构名称")
    private String inspectOrgName;

    @ApiModelProperty(value = "检验机构统一信用代码")
    @ExcelProperty(value = "检验机构统一信用代码")
    private String inspectOrgCode;

    @ApiModelProperty(value = "检验类型")
    @ExcelProperty(value = "检验/检测类型")
    private String inspectType;

    @ApiModelProperty(value = "检验结论")
    @ExcelProperty(value = "检验/检测结论")
    private String inspectConclusion;

    @ApiModelProperty(value = "检验日期")
    @ExcelProperty(value = "检验日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String inspectDate;

    @ApiModelProperty(value = "下次检验日期")
    @ExcelProperty(value = "下次检验日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String nextInspectDate;

    @ApiModelProperty(value = "检验人员名称")
    @ExcelProperty(value = "检验人员名称")
    private String inspectStaff;

    @ApiModelProperty(value = "检验人员身份证号")
    @ExcelProperty(value = "检验人员身份证号")
    private String inspectStaffIDNumber;

    @ApiModelProperty(value = "检验报告编号")
    @ExcelProperty(value = "检验报告编号")
    private String inspectReportNo;

    //--------------------------------------------------------------------维保信息
    @ApiModelProperty(value = "维保单位统一信用代码")
    @ExcelProperty(value = "维保单位统一信用代码")
    private String meUnitCreditCode;

    @ApiModelProperty(value = "维保单位")
    @ExcelProperty(value = "维保单位")
    private String meUnitName;

    @ApiModelProperty(value = "维保合同开始时间")
    @ExcelProperty(value = "维保合同开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private String informStart;

    @ApiModelProperty(value = "维保合同结束时间")
    @ExcelProperty(value = "维保合同结束时间")
    @DateTimeFormat("yyyy-MM-dd")
    private String informEnd;

    @ApiModelProperty(value = "维保人员一")
    @ExcelProperty(value = "维保人员一")
    private String meMaster;

    @ApiModelProperty(value = "维保人员一身份证号")
    @ExcelProperty(value = "维保人员一身份证号")
    private String meMasterId;

    @ApiModelProperty(value = "维保人员一联系方式")
    @ExcelProperty(value = "维保人员一联系方式")
    private String meMasterPhone;

    @ApiModelProperty(value = "维保人员二")
    @ExcelProperty(value = "维保人员二")
    private String meMaster1;

    @ApiModelProperty(value = "维保人员二身份证号")
    @ExcelProperty(value = "维保人员二身份证号")
    private String meMaster1Id;

    @ApiModelProperty(value = "维保人员二联系方式")
    @ExcelProperty(value = "维保人员二联系方式")
    private String meMaster1Phone;

    //--------------------------------------------------------------------电梯索道----技术参数
    @ApiModelProperty(value = "额定速度（m/s）")
    @ExcelProperty(value = "额定速度（m/s）")
    @NumberFormat("#.##")
    private BigDecimal ratedSpeed;

    @ApiModelProperty(value = "额定速度（上行）（m/s）")
    @ExcelProperty(value = "额定速度（上行）（m/s）")
    @NumberFormat("#.##")
    private BigDecimal ratedSpeedUp;

    @ApiModelProperty(value = "额定速度（下行）（m/s）")
    @ExcelProperty(value = "额定速度（下行）（m/s）")
    @NumberFormat("#.##")
    private BigDecimal ratedSpeedDown;

    @ApiModelProperty(value = "提升高度（m）")
    @ExcelProperty(value = "提升高度（m）")
    @NumberFormat("#.##")
    private BigDecimal liftingHeight;

    @ApiModelProperty(value = "额定载重量（kg）")
    @ExcelProperty(value = "额定载重量（kg）")
    @NumberFormat("#.##")
    private BigDecimal ratedLoadCapacity;

    @ApiModelProperty(value = "层数（层）")
    @ExcelProperty(value = "层数（层）")
    private Integer storey;

    @ApiModelProperty(value = "站数（站）")
    @ExcelProperty(value = "站数（站）")
    private Integer stand;

    @ApiModelProperty(value = "门数")
    @ExcelProperty(value = "门数")
    private Integer numberDoors;

    @ApiModelProperty(value = "控制方式")
    @ExcelProperty(value = "控制方式", converter = DictParamsConverter.class)
    private String controlMode;

    @ApiModelProperty(value = "名义速度（m/s）")
    @ExcelProperty(value = "名义速度（m/s）")
    @NumberFormat("#.##")
    private BigDecimal nominalSpeed;

    @ApiModelProperty(value = "倾斜角")
    @ExcelProperty(value = "倾斜角")
    @NumberFormat("#.##")
    private BigDecimal angleRoll;

    @ApiModelProperty(value = "名义宽度（mm）")
    @ExcelProperty(value = "名义宽度（mm）")
    @NumberFormat("#.##")
    private BigDecimal nominalWidth;

    @ApiModelProperty(value = "使用区段长度（m）")
    @ExcelProperty(value = "使用区段长度（m）")
    @NumberFormat("#.##")
    private BigDecimal useSectionLength;

    @ApiModelProperty(value = "输送能力（P/h）")
    @ExcelProperty(value = "输送能力（P/h）")
    private String conveyingCapacity;

    @ApiModelProperty(value = "油缸数量")
    @ExcelProperty(value = "油缸数量")
    private Integer numberCylinders;

    @ApiModelProperty(value = "顶升方式")
    @ExcelProperty(value = "顶升方式", converter = DictParamsConverter.class)
    private String jackingType;

    @ApiModelProperty(value = "整机防爆标志")
    @ExcelProperty(value = "整机防爆标志")
    private String explosionproofSignComplete;

    @ApiModelProperty(value = "区域防爆等级")
    @ExcelProperty(value = "区域防爆等级", converter = DictParamsConverter.class)
    private String explosionproofGrade;

    @ApiModelProperty(value = "轿门位置")
    @ExcelProperty(value = "轿门位置")
    private String doorPosition;

    @ApiModelProperty(value = "原设备代码")
    @ExcelIgnore
    private String originalEquCode;

    @ApiModelProperty(value = "序号")
    @ExcelProperty(value = "序号")
    private String xaSerial;

    @ApiModelProperty(value = "资料是否齐全（0齐全， 1不齐全）-西安数据导入")
    @ExcelIgnore
    private Integer isCompleteXa;

    @ApiModelProperty(value = "监管履历主键")
    @ExcelProperty(value = "监管履历主键")
    private String resumeSeq;

    @ApiModelProperty(value = "业务类型")
    @ExcelProperty(value = "业务类型")
    private String businessType;

    @ApiModelProperty(value = "创建时间")
    @ExcelProperty(value = "创建时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private String createDate;

    @ApiModelProperty(value = "创建人名称")
    @ExcelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "业务单号")
    @ExcelProperty(value = "业务单号")
    private String businessId;

    @ApiModelProperty(value = "审批单位")
    @ExcelProperty(value = "审批单位")
    private String approvalUnit;

    @ApiModelProperty(value = "审批通过时间")
    @ExcelProperty(value = "审批通过时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private String approvalDate;

    @ApiModelProperty(value = "电梯状态")
    @ExcelProperty(value = "电梯状态", converter = EquStateConverter.class)
    private String equState;

    @ApiModelProperty(value = "所属辖区")
    @ExcelProperty(value = "所属辖区")
    private String supervisionDepartment;

    @ApiModelProperty(value = "所属辖区代码")
    @ExcelProperty(value = "所属辖区代码")
    private String supervisionDepartmentCode;

    @ApiModelProperty(value = "市场监管所")
    @ExcelProperty(value = "市场监管所")
    private String supervisionOffice;

    @ApiModelProperty(value = "市场监管所代码")
    @ExcelProperty(value = "市场监管所代码")
    private String supervisionOfficeCode;

    public void setoRegUnit(String oRegUnit) {
        this.oRegUnit = oRegUnit;
    }

    public void setoRegDate(String oRegDate) {
        this.oRegDate = oRegDate;
    }

    public String getoRegUnit() {
        return oRegUnit;
    }

    public String getoRegDate() {
        return oRegDate;
    }
}