package com.yeejoin.amos.boot.module.elevator.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
/**
 * 安全追溯-安全保护装置
 *
 * @author cpp
 * @date 2023-04-21 11:08:36
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="protectionDevices", description="安全保护装置技术参数")
public class ProtectionDevicesModel extends BaseDto {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "装置号")
    private String deviceNumber;
    @ApiModelProperty(value = "型号规格")
    private String typeSpecification;
    @ApiModelProperty(value = "制造单位")
    private String manufactureCompany;
    @ApiModelProperty(value = "制造日期")
    private Date manufacturingDate;
    @ApiModelProperty(value = "产品编号")
    private String code;
    @ApiModelProperty(value = "型式试验证合格证号")
    private String certificateNumber;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "数量")
    private Integer quantity;
    @ApiModelProperty(value = "名称")
    private String designation;
    @ApiModelProperty(value = "型号(锅炉,压力容器) ")
    private String model;
    @ApiModelProperty(value = "规格(锅炉,压力容器)")
    private String specification;

}
