package com.yeejoin.amos.boot.module.elevator.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 设备使用信息表
 *
 * @author system_generator
 * @date 2022-01-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="EquipmentUseInfoDto", description="设备使用信息表")
public class EquipmentUseInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "使用单位id")
    private Long useUnitId;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useOrganizationCode;

    @ApiModelProperty(value = "产权单位名称")
    private String propertyUnitName;

    @ApiModelProperty(value = "产权单位id")
    private Long propertyUnitId;

    @ApiModelProperty(value = "产权统一信用代码")
    private String propertyOrganizationCode;

    @ApiModelProperty(value = "使用地址")
    private String useAddress;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "使用场所")
    private String useSite;

    @ApiModelProperty(value = "使用场所编码")
    private String useSiteCode;

    @ApiModelProperty(value = "特设编码")
    private String specialCode;

    @ApiModelProperty(value = "设备注册代码")
    private String registerCode;

    @ApiModelProperty(value = "96333识别码")
    private String rescueCode;

    @ApiModelProperty(value = "使用登记证编码")
    private String registerLicenceCode;

    @ApiModelProperty(value = "登记机关")
    private String registerOrg;

    @ApiModelProperty(value = "登记机关id")
    private Long registerOrgId;

    @ApiModelProperty(value = "登记日期")
    private Date registerTime;

    @ApiModelProperty(value = "发证日期")
    private Date issueLicenceTime;

    @ApiModelProperty(value = "投入使用日期")
    private Date startUseTime;

    @ApiModelProperty(value = "设备id")
    private Long equipmentId;

}
