package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
@Data
@ApiModel(value = "DutyFireFightingDto", description = "微型消防站值班")
public class DutyFireFightingDto implements Serializable {
	
    private static final long serialVersionUID = 1L;
	
    @ApiModelProperty(value = "用户id")
    private String userId;
	
    @ApiModelProperty(value = "用户名称")
    private String userName;
    
    @ApiModelProperty(value = "单位ID")
    private String teamId;
   
    @ApiModelProperty(value = "单位名称")
    private String teamName;
    
    @ApiModelProperty(value = "岗位id")
    private String postType;
    
    @ApiModelProperty(value = "岗位名称")
    private String postTypeName;
    
    @ApiModelProperty(value = "值班信息")
    private List<DutyPersonShiftDto> dutyShift;
    
    @ApiModelProperty(value = "值班开始时间")
    private String startTime;
    
    @ApiModelProperty(value = "值班结束时间")
    private String endTime;
    
    @ApiModelProperty(value = "微型消防站")
    private String fireFighting;
    
    @ApiModelProperty(value = "微型消防站Id")
    private String fireFightingId;

    @ApiModelProperty(value = "值班区域")
    private String dutyArea;

    @ApiModelProperty(value = "值班区域Id")
    private String dutyAreaId;
    
}

