package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.CylinderFillingRecordStatisticsUnitDayServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderFillingRecordStatisticsUnitDayDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 *
 * @author system_generator
 * @date 2024-06-05
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/cylinder-filling-record-statistics-unit-day")
public class CylinderFillingRecordStatisticsUnitDayController extends BaseController {

    @Autowired
    CylinderFillingRecordStatisticsUnitDayServiceImpl cylinderFillingRecordStatisticsUnitDayServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<CylinderFillingRecordStatisticsUnitDayDto> save(@RequestBody CylinderFillingRecordStatisticsUnitDayDto model) {
	    model = cylinderFillingRecordStatisticsUnitDayServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<CylinderFillingRecordStatisticsUnitDayDto> updateBySequenceNbrCylinderFillingRecordStatisticsUnitDay(@RequestBody CylinderFillingRecordStatisticsUnitDayDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderFillingRecordStatisticsUnitDayServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderFillingRecordStatisticsUnitDayServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<CylinderFillingRecordStatisticsUnitDayDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderFillingRecordStatisticsUnitDayServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<CylinderFillingRecordStatisticsUnitDayDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<CylinderFillingRecordStatisticsUnitDayDto> page = new Page<CylinderFillingRecordStatisticsUnitDayDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderFillingRecordStatisticsUnitDayServiceImpl.queryForCylinderFillingRecordStatisticsUnitDayPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderFillingRecordStatisticsUnitDayDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderFillingRecordStatisticsUnitDayServiceImpl.queryForCylinderFillingRecordStatisticsUnitDayList());
	}
}
