package com.yeejoin.amos.boot.module.jczs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 消息流水表
 *
 * @author system_generator
 * @date 2022-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_msg_log")
public class MsgLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 关联编号
     */
	@TableField("relation_code")
    private String relationCode;

    /**
     * 消息类型（超期预警、许可超期、风险预警）
     */
	@TableField("msg_type")
    private String msgType;

    /**
     * 消息类型名称
     */
    private String msgTypeName;

    /**
     * 消息内容
     */
	@TableField("body")
    private String body;

    /**
     * 接收者账号
     */
	@TableField("target_code")
    private String targetCode;

    /**
     * 接收者名称
     */
	@TableField("target_name")
    private String targetName;

    /**
     * 发送日期
     */
	@TableField("send_time")
    private Date sendTime;

    /**
     * 站端类型： WEB,APP
     */
	private String terminalType;

    /**
     * 是否已读
     */
    @TableField("is_read")
    private Boolean isRead = false;

    private String companyName;

    private String regionCode;
}
