package com.yeejoin.amos.boot.module.jczs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 液化气体气瓶充装信息-充装记录
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_record")
@ApiModel(value="TzCylinderFillingRecord对象", description="液化气体气瓶充装信息-充装记录")
public class CylinderFillingRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;





    @ApiModelProperty(value = "充装记录Id")
    private String fillingRecordId;

    @ApiModelProperty(value = "充装开始时间")
    @TableField("filling_starttime")
    private String fillingStarttime;

    @ApiModelProperty(value = "充装结束时间")
    @TableField("filling_endtime")
    private String fillingEndtime;

    @ApiModelProperty(value = "充装人员姓名")
    private String fillingUser;

    @ApiModelProperty(value = "充装量（Kg）")
    private Double fillingQuantity;

    @ApiModelProperty(value = "室温")
    private Double temperature;

    @ApiModelProperty(value = "异常情况")
    private Integer abnormal;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "1初次同步数据   2上层系统已同步数据   0已删除数据")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "不能与充装人员姓名相同")
    private String inspectorName;

    @ApiModelProperty(value = "充装前检查Id")
    private String fillingBeforeId;

    @ApiModelProperty(value = "充装后复查ID")
    private String fillingCheckId;

    @ApiModelProperty(value = "充装信息审核ID")
    private String fillingExamineId;

    @ApiModelProperty(value = "是否保存到es（1标识已经保存过）")
    private String isNotEs;

}
