package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 气瓶合规性校验结果枚举
 */
@Getter
@AllArgsConstructor
public enum CylinderComplianceStatus {

    /**
     * 气瓶不存在
     */
    NOT_EXIST("01", "气瓶不存在"),

    /**
     * 气瓶未登记
     */
    NOT_REGISTERED("02", "气瓶未登记"),

    /**
     * 气瓶检验超期
     */
    EXPIRED_INSPECTION("03", "气瓶检验超期"),

    /**
     * 气瓶合规
     */
    COMPLIANT("04", "气瓶合规");

    private final String code;
    private final String desc;

    /**
     * 根据code获取枚举值
     */
    public static CylinderComplianceStatus fromCode(String code) {
        for (CylinderComplianceStatus status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        throw new IllegalArgumentException("未知的合规状态码: " + code);
    }

    @Override
    public String toString() {
        return "CylinderComplianceStatus{" +
                "code='" + code + '\'' +
                ", desc='" + desc + '\'' +
                '}';
    }
}

