package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum PipelineEnum {


    PRESSURE_PIPELINE("压力管道", "8000"),

    INDUSTRIAL_PIPELINE("工业管道", "8300"),
    LONG_DISTANCE_PIPELINE("长输管道", "8100"),
    COMMON_PIPELINE("公用管道", "8200");

    private final String name;

    private final String code;


    public static String getMessage(String code) {
        for (PipelineEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }

    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (ConstructionEnum e : ConstructionEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
