package com.yeejoin.amos.boot.module.jg.api.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCarEqu;
import lombok.Data;

import java.util.Date;

/**
 * @author chang xiangyu 2024/11/12
 */
@Data
public class ShCarEquVo {
    /**
     * primary key
     */
    private String sequenceNbr;

    /**
     * tzs_sh_car表主键
     */
    private String carId;

    /**
     * 设备编号sequenceCode
     */
    private String sequenceCode;

    /**
     * 设备代码
     */
    private String equCode;

    /**
     * 设备型号
     */
    private String equType;

    /**
     * 制造日期
     */
    private Date produceDate;

    /**
     * 安装日期
     */
    private Date equInstalldate;

    /**
     * 检查日期
     */
    private Date equCheckdate;

    /**
     * firstDate
     */
    private Date equFirstdate;

    /**
     * 序号
     */
    private String serialNumber;

    /**
     * sub_DM 代码
     */
    private String equDm;

    /**
     * 单位编号 equDwbh
     */
    private String UseInnerCode;

    /**
     * 公称工作压力(MPa) equQpgc
     */
    private String nominalWorkingPressure;

    /**
     * 气瓶批号
     */
    private String batchNumber;

    /**
     * PFZZDW PF制造单位
     */
    private String equPfzzdw;

    /**
     * isChange
     */
    private Integer ischange;

    /**
     * 报告编号
     */
    private String reportcode;

    /**
     * BFReportCode
     */
    private String bfreportcode;

    /**
     * 操作方式
     */
    private String equCzfs;

    /**
     * 是否认领
     */
    private String claimedFlag;

    private String produceUnitName;

    private String equList;
    private String equCategory;
    private String equDefine;

    /**
     * 是否车用气瓶
     */
    private String whetherVehicleCylinder;


    public ShCarEquVo(ShCarEqu shCarEqu) {
        this.setSequenceNbr(shCarEqu.getSequenceNbr());
        this.setCarId(shCarEqu.getCarId());
        this.setEquCode(shCarEqu.getEquCode());
        this.setUseInnerCode(shCarEqu.getEquDwbh());
        this.setNominalWorkingPressure(shCarEqu.getEquQpgc());
        this.setProduceUnitName(shCarEqu.getProduceUnitName());
    }
}
