package com.yeejoin.amos.boot.module.jg.biz.discardOrder.strategy;

import cn.hutool.core.util.ReUtil;
import com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory.support.SupportableDiscardOrderCheck;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class GenericDiscardOrderCheck implements SupportableDiscardOrderCheck {
    @Override
    public boolean support(String clazz) {
        return JgMaintainNoticeServiceImpl.class.getSimpleName().equals(clazz) ||
                JgTransferNoticeServiceImpl.class.getSimpleName().equals(clazz) ||
                JgReformNoticeServiceImpl.class.getSimpleName().equals(clazz) ||
                JgMaintenanceContractServiceImpl.class.getSimpleName().equals(clazz) ||
                JgChangeRegistrationReformServiceImpl.class.getSimpleName().equals(clazz);
    }

    @Override
    public Boolean check(List<String> records) {
        return true;
    }

    public static String buildErrorMsg(String applyNo) {
        String prefix = ReUtil.get("^[a-zA-Z]+", applyNo, 0);
        String name = Optional.ofNullable(ApplicationFormTypeEnum.getByCode(prefix)).map(ApplicationFormTypeEnum::getBusinessName).orElse("");
        return String.format("%s:%s", name, applyNo);
    }
}
