package com.yeejoin.amos.boot.module.jg.biz.edit.factory;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class ColumnDiffFactory {
    private final List<ColumnDiff> columnDiffs;
    private final Map<Class<?>, ColumnDiff> diffCache = new ConcurrentHashMap<>();

    public ColumnDiff getDiffAdapter(Class<?> clazz) {
        return diffCache.computeIfAbsent(clazz, (k) -> {
            for (ColumnDiff columnDiff : columnDiffs) {
                if (columnDiff.supports(clazz)) {
                    return columnDiff;
                }
            }
            throw new BadRequest("no found handler for class: " + clazz);
        });
    }
}
