package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.changeRegistrationReform;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationReformEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.backup.DefaultEquipBackupManager;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationReformEqServiceImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class ChangeRegisterReformBackupManager extends DefaultEquipBackupManager {

    private final JgChangeRegistrationReformEqServiceImpl changeRegistrationReformEqService;

    public ChangeRegisterReformBackupManager(ApplicationContext applicationContext, JgChangeRegistrationReformEqServiceImpl changeRegistrationReformEqService) {
        super(applicationContext);
        this.changeRegistrationReformEqService = changeRegistrationReformEqService;
    }

    @Override
    public List<String> getRecords(String bizId) {
        List<JgChangeRegistrationReformEq> eqDtoList = changeRegistrationReformEqService.list(new LambdaQueryWrapper<JgChangeRegistrationReformEq>().eq(JgChangeRegistrationReformEq::getEquipTransferId, bizId));
        return eqDtoList.stream().map(JgChangeRegistrationReformEq::getEquId).collect(Collectors.toList());
    }

    @Override
    public String getBizType() {
        return BusinessTypeEnum.JG_RENOVATION_REGISTRATION.name();
    }
}
