package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationTransferEq;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgChangeRegistrationTransferEqMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationTransferEqService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationTransferEqDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 移装变更登记设备关系表服务实现类
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Service
public class JgChangeRegistrationTransferEqServiceImpl extends BaseService<JgChangeRegistrationTransferEqDto,JgChangeRegistrationTransferEq,JgChangeRegistrationTransferEqMapper> implements IJgChangeRegistrationTransferEqService {
    /**
     * 分页查询
     */
    public Page<JgChangeRegistrationTransferEqDto> queryForJgChangeRegistrationTransferEqPage(Page<JgChangeRegistrationTransferEqDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JgChangeRegistrationTransferEqDto> queryForJgChangeRegistrationTransferEqList()   {
        return this.queryForList("" , false);
    }

    /**
     * 新增移装设备关系表
     * @param transferEq
     */
    public boolean saveOrUpdateTransferEqData(JgChangeRegistrationTransferEq transferEq) {
        return this.saveOrUpdate(transferEq);
    }

    public JgChangeRegistrationTransferEq getDetailByEquipTransferId(String equipTransferId) {
        return this.getOne(new QueryWrapper<JgChangeRegistrationTransferEq>().eq("equip_transfer_id", equipTransferId));
    }

    public JgChangeRegistrationTransferEq getDetailByEquIdAndTransferId(String equipId, String equipTransferId) {
        return this.getOne(new QueryWrapper<JgChangeRegistrationTransferEq>().eq("equ_id", equipId).eq("equip_transfer_id", equipTransferId));
    }

    public boolean updateDate(JgChangeRegistrationTransferEq eq, LambdaQueryWrapper<JgChangeRegistrationTransferEq> eqWapper) {
        return this.update(eq,eqWapper);
    }


}